% Computes the difference between the second nearest point to xmax and xmax. (to compute alpha Feigenbaum constant)
% A_r (scalar): value of parameter 'a' of the cubic map where the 2^r-cycle has a point on the local maximum xmax
% r (scalar): integer corresponding to A_r
% d_r (scalar): difference (can be negative) between the second nearest and xmax
function d_r = dist_second_nearest(A_r,r)

global a; a = A_r; % Gives value of A_r to diffEq through global variable

x0=0.5; % Initial condition of simulation
N=1000; % Length of simulation
Nlast=2^r; % Only keep the last Nlast points. (2^r means it can identify up to a 2^r-cycle)

X = compute_map(x0,N); % Simulation
X = X(end-Nlast+1:end); % Only keep the converged points, on the limit cycle


xmax = sqrt(a/3); 
[value, index] = sort( abs(X-xmax ) ); % Sort X by increasing distance with xmax
xsecondnearest = X(index(2)); % Second nearest point to xmax

d_r = xsecondnearest-xmax; % Difference not distance (can be negative)

end
