% Executes the dichotomy, to find an approximation of A_r, where xnear's relative position with xmax changes sign.
% ainf and asup (scalars): Lower and upper bounds that contain A_r.
% A_r (scalar)
function A_r = dichotomy(ainf,asup)

p =1e-10; % Precision of A_r

rel_pos_ainf = rel_pos_xnear(ainf); % Compute the relative position for the boundaries
rel_pos_asup = rel_pos_xnear(asup);

if rel_pos_ainf == rel_pos_asup % Error if both boundaries have the same relative position, dichotomy makes no sense.
	A_r = ainf; disp('error dichitomy rel_pos_ainf == rel_pos_asup');
end


while asup-ainf>p % Repeat while the error is bigger than the desired precision
	amid = (asup+ainf)/2; % Mid-point
	rel_pos_amid = rel_pos_xnear( amid ); % Compute relative position at mid-point
	if rel_pos_asup == rel_pos_amid
		asup = amid; % Lower the upper bound
	else 
		ainf = amid; % Raise the lower bound
	end
end

A_r = (asup+ainf)/2; % Approximate answer

end


