% Numerically compute the iterations of Feigenbaum constants, delta_r and alpha_r
% A (vector size (r+1)*1 ): Contains A_0, ..., A_r. Values of parameter 'a' at which a point of the 2^r-cycle is at x_max
% delta (vector size (r-1)*1 ): Contains delta_0, ...,delta_(r-1). delta(r) = ( A(r+1)-A(r) )/( A(r+2)-A(r+1) )
% d (vector size r*1 ): Contains d_1, ...,d_r. Difference, at a=A_r, between second nearest point of the 2^r-cycle and x_max
% alpha (vector size (r-1)*1 ): Contains alpha_1, ..., alpha_(r-1).  alpha(r) = d(r)/d(r+1)
function [A, delta, d, alpha] = Feigenbaum_constants()

rmax = 14; % Compute up to A_rmax
A = zeros(rmax+1,1); % To store A_r

ainf = 1;
achaos = 2.30228346; % Where chaos appears
Na = 100; %50; % Number of steps for a_i


for	r=0:rmax % Loop until A_rmax
	a = linspace(ainf,achaos,Na); % Subdivided interval [ainf, achaos]

	rel_pos_ainf = rel_pos_xnear( ainf ); % Initial relative position

	j=1;
	while( rel_pos_ainf == rel_pos_xnear( a(j) ) ) % Find when the relative position changes
		j=j+1; % Increment for a(j)
		if j>Na; disp('Error: j>Na, because precision is insufficient (achaos or Niter...)'); end; % Error if relative position never changes
	end

	A(r+1) = dichotomy(a(j-1),a(j)); % The relative position changes between a(j-1) and a(j), so dichotomy to find A_r
	disp(['A_' num2str(r) ' = ' num2str(A(r+1),8)]); % Display A_r with 8 significant figures
	
	ainf = a(j); % Reset boundary of the interval
end


delta = zeros(rmax-1,1); % To store delta_r
for r=0:rmax-2
	delta(r+1) = ( A(r+2)-A(r+1) )/( A(r+3)-A(r+2) );
	disp(['delta_' num2str(r) ' = ' num2str(delta(r+1),6)]); % Display delta_r with 6 significant figures
end



%%%%%
d = zeros(rmax,1); % To store d_r
for r=1:rmax
	d(r) = dist_second_nearest( A(r+1),r );
	disp(['d_' num2str(r) ' = ' num2str(d(r),8)]); % Display d_r with 8 significant figures
end

alpha = zeros(rmax-1,1); % To store alpha_r
for r=1:rmax-1
	alpha(r) = d(r)/d(r+1);
	disp(['alpha_' num2str(r) ' = ' num2str(alpha(r),6)]); % Display delta_r with 6 significant figures
end


