#!/usr/bin/env python

# This code generates a sequence of exponentially correlated and
# Gaussian distributed random numbers.

# author: Sai Lyu, EPFL, Nov 2019

import math
import random

tau=10
nstep=100000

g1=open('DATA.dat','w')
# Gn is a sequence of independent Gaussian numbers with zero mean 
# and unit variance.
f=math.exp(-1.0/tau)

Alist=[]
aold=random.gauss(0,1)
Alist.append(aold)
for ia in range(nstep) :
  anew=f*aold+math.sqrt(1-f**2)*float(random.gauss(0,1))
  Alist.append(anew)
  aold=anew
  g1.write(str(anew)+'\n')

g1.close()

def var2 (Alist) :
  var2=0
  suma=sum(Alist)
  for i in range (len(Alist))  :
     var2 += (Alist[i]-suma/len(Alist))**2/len(Alist)
  return var2

print 'The average is ', sum(Alist)/len(Alist)
print 'The sigma^2 is ', var2(Alist)
