#!/usr/bin/env python

import mc
import numpy as np

nsize = 10000
verbose = 1


#various Monte Carlo methods

n = nsize

task = mc.montecarlo(n, verbose=verbose)
task.sampling()
task.direct()
task.importance()

#error estimate
n_init = 1000
n_final = 10000
n_step = 200
for i in range(n_init, n_final, n_step):
   n = i
   task = mc.montecarlo(n,verbose=0)
   task.direct()
   task.importance()
   print('{0:10} {1:.10f} {2:.10f}'.format(n, task.ds_1, task.ds_2))


#Metropolis

nskip = 1
nburnin = nsize
h = 0.9

task = mc.metropolis(nsize, nskip, nburnin, h, verbose)
task.run()


#autocorrelation

lmax = 20               # the largest l of the series
nrep = 10               # perform some independent experiments and do an ensemble-average 
corr = np.zeros((lmax,2))       # create a two column array to store C(l) vs. l.
corr[:,0] = np.arange(1,lmax+1,1)
for i in range(lmax):
   c = 0
   for j in range(nrep):
       task = mc.metropolis(nsize, i+1, nburnin, h, verbose)
       task.run()
       c += task.corr
   corr[i,1] = c/nrep

np.savetxt('autocorr.dat', corr)    # for plotting
