!!!
! Generates a random walk in one dimension 
!  author: Gabriele Sclauzero (EPFL, Lausanne), Sept. 2010 
!!!
program ran_gauss

implicit none
integer :: nwalk, nstep

integer :: i, j, seed, x, t(9)
integer, allocatable :: x2ave(:)
character(len=256) :: filename
character(len=16) :: nstepc, nwalkc, date, time, zone

real, external :: ran2

write(*,'(A)',advance='NO') "enter # of walkers: " 
read(*,'(I22)') nwalk
write(*,'(A)',advance='NO') "enter # of steps: "
read(*,'(I22)') nstep

!! fixed seed (for debugging purposes)
!seed = 123456789
!! random seed 
call date_and_time(date,time,zone,t) 
!seed = t(8)+1000*(t(7) + 60*(t(6) + 60*(t(5) + 24*(t(3) - 1 + 31*(t(2) - 1 +12*t(1))))))
!! the version above generates overflows... some compilers don't like
seed = t(8)+1000*(t(7) + 60*(t(6) + 60*(t(5))))
!seed = imsec + 60*(imin + 60*(ihr + 24*(iday - 1 + 31*(imon - 1 +12*iyr))))
seed = ior(seed,1) ! to ensure that seed is an odd number

allocate( x2ave(nstep) )
x2ave(:) = 0

do i = 1,nwalk

   x = 0 ! current location of the walker

   do j = 1,nstep

      if ( ran2(seed) < 0.5 ) then
         x = x + 1
      else
         x = x - 1
      endif

      x2ave(j) = x2ave(j) + x*x

   enddo 

enddo

x2ave = x2ave / nwalk

! write mean square displacement to file
write(nwalkc,'(I16)') nwalk
write(nstepc,'(I16)') nstep
filename = 'msd_'//trim(adjustl(nwalkc))//'walkers-'&
  //trim(adjustl(nstepc))//'steps'

open(2,file=trim(filename),action="write",status="unknown")
write(2,'(2I14)') (i, x2ave(i), i=1,nstep)
close(2)

deallocate( x2ave )

end program
