!!!
! Generates a normal distribution using two different methods 
!  author: Gabriele Sclauzero (EPFL, Lausanne), Sept. 2010 
!!!
program ran_gauss

implicit none
integer :: method, nsum, ntry

integer, parameter :: nbins=100 ! max number of histogram bins
real(8), parameter :: rmin=-4.d0, rmax=-rmin ! range for binning
integer :: i, j, seed, cnt(nbins), nran, t(9)
real(8) :: res, invbinw, rave, r2ave, v1, v2, r2, fac, sgm
character(len=256) :: filename
character(len=16) :: methc, nsumc, ntryc, date, time, zone

real, external :: ran2

write(*,'(A)',advance='NO') "method (1=Box-Muller;2=C.L. theor.):"
read(*,'(I22)') method 

if ( method == 2 ) then
   write(*,'(A)',advance='NO') "number of R.N. to sum:"
   read(*,'(I22)') nsum 
   sgm = sqrt(1.d0/12.d0/dble(nsum))
endif

write(*,'(A)',advance='NO') "number of tries:"
read(*,'(I22)') ntry

!! fixed seed (for debugging purposes)
!seed = 123456789
!! random seed 
call date_and_time(date,time,zone,t) 
!seed = t(8)+1000*(t(7) + 60*(t(6) + 60*(t(5) + 24*(t(3) - 1 + 31*(t(2) - 1 +12*t(1))))))
!! the version above generates overflows... some compilers don't like
seed = t(8)+1000*(t(7) + 60*(t(6) + 60*(t(5))))
!seed = imsec + 60*(imin + 60*(ihr + 24*(iday - 1 + 31*(imon - 1 +12*iyr))))
seed = ior(seed,1) ! to ensure that seed is an odd number

cnt(:) = 0
invbinw = nbins / dble(rmax - rmin)
rave = 0.d0
r2ave = 0.d0
nran = 0

do i = 1,ntry

   selectcase ( method )

   case ( 1 )
      ! Box-Muller
      v1 = 2.d0*ran2(seed) - 1.d0
      v2 = 2.d0*ran2(seed) - 1.d0
      r2 = v1**2 + v2**2

      if ( r2 >= 1.d0 ) cycle

      nran = nran + 1
      fac = sqrt( -2.d0*log(r2)/r2 )
      res = v2*fac
      !
   case ( 2 )
      ! central limit theorem
      res = 0.d0
      do j = 1,nsum
         res = res + ran2(seed)
      enddo

      nran = nran + 1
      res = (res/dble(nsum) - 0.5d0) / sgm
      !
   case default
      write(*,'(A,I22)') "unknown method",method
      stop
   endselect

   call binning(res)

   rave = rave + res
   r2ave = r2ave + res*res

enddo

rave = rave / dble(nran)
r2ave = r2ave / dble(nran)

write(*,'(A,F14.9)') 'average  =', rave/dble(nran)
write(*,'(A,F14.9)') 'std. dev.=', sqrt(r2ave - rave*rave)

! write histogram to file
write(ntryc,'(I16)') ntry
selectcase ( method )
case ( 1 )
   methc = 'BM'
case ( 2 )
   write(nsumc,'(I16)') nsum
   methc = 'CL'//trim(adjustl(nsumc))
endselect
filename = 'histo-gauss'//trim(adjustl(methc))// '_'// &
 trim(adjustl(ntryc))

open(2,file=trim(filename),action="write",status="unknown")
write(2,'(2F14.6)') ( (dble(i)-0.5)/invbinw + rmin, &
   cnt(i)/real(nran)*invbinw, i=1,nbins )
close(2)



!!!
contains
!!!

subroutine binning(r)

real(8) :: r

integer :: ibin
real(8) :: s

s = r - rmin

if ( s < rmax-rmin ) then
   ibin = int(invbinw*s) + 1
   cnt(ibin) = cnt(ibin) + 1
endif

end subroutine


end program
