import numpy as np
import matplotlib.pyplot as plt

# Parameters for the theoretical curve
nbins=200
rmin=-4
rmax=-rmin

# Insert here the name of the files to plot
filenamel=[
        'histo-gaussCL10_10000',
        ]

for filename in filenamel:
    f=open(filename,'r')
    lx=[]
    ly=[]
    for i in f:
        l=i.split()
        lx.append(float(l[0]))
        ly.append(float(l[1]))
    f.close()
    plt.plot(lx,ly,label=filename)

x=np.zeros(nbins)
gauss=np.zeros(nbins)
for i in range(nbins):
    x[i]=(i+0.5)/nbins*(rmax-rmin) + rmin
gauss=np.exp(-np.square(x)/2)/(np.sqrt(2*np.pi))
plt.plot(x,gauss,label='Theo.')
plt.legend()
plt.show()
