import numpy as np
import matplotlib.pyplot as plt
import scipy.special

# Parameters for the theoretical curve
n=100 # Number of points for the incomplete gamma function
xmax=40 # Maximum values

# Insert here the name of the files to plot
filef=[
    'chisq-ran0_1000x11000-11',
    ]

xig=np.zeros(n)
yig=np.zeros(n)

i=0
for filename in filef:
    x=[]
    y=[]
    for l in open(filename,'r'):
        x.append(float(l.split()[0]))
        y.append(float(l.split()[2]))
    x=np.array(x)
    y=np.array(y)
    plt.plot(x/2,y,label=filef[i])
    i+=1

for i in range(n):
    xig[i]=i/n*xmax
    yig[i]=scipy.special.gammainc(5,xig[i])

plt.plot(xig,yig,'.-',label='Theo.')


plt.legend(loc=4)
plt.ylabel('$\chi^2$')
plt.xlim(0,xmax)
plt.ylim(0,1.01)
plt.show()
                

