import matplotlib.pyplot as plt
from scipy.stats import maxwell, norm
from scipy.stats import linregress
from MD import *


dt=0.0046
Q=10.
nsteps=450
nsteps_eq=200
Nruns = 4
T=0.7807




D_msd=[]
D_tmp=[]
D_std=[]
t = np.linspace(1,nsteps,nsteps)*dt
cut = 50
msd_mean=np.zeros(nsteps)

N, L, pos, vel, xi, lns = read_pos_vel('sampleNVT94.4.dat')

output = {'pos': pos, 'vel': vel}


for i in range(Nruns):

    # Change T 
    output = run_NVT(output['pos'], output['vel'], L, nsteps_eq, N, dt, T, Q)

    # Run simulation in VNT
    output = run_NVT(output['pos'], output['vel'], L, nsteps, N, dt, T, Q, output['xi'],output['lns'])

    slope, intercept, r, p, se = linregress(t[cut:],output['msd'][cut:])

    D_tmp.append(slope/6*3.4E-10**2*4.6286E+11*1E+4)

    msd_mean += output['msd']/Nruns



# MSD
slope, intercept, r, p, se = linregress(t[cut:],msd_mean[cut:])

D_msd=slope/6*3.4E-10**2*4.6286E+11*1E+4
D_std=np.std(D_tmp)/np.sqrt(Nruns)

print(D_msd, D_std)

