/*
 * Clock V0.4
 *
 * Created: 5.04.2018 09:22:59
 * Author : Nicolas Turin
 */ 


#include "interruption.h"
#include <stdlib.h>


#define ADCref 5 // ADC reference voltage

// eeprom adresses of parameters
// #define adressTimeSecondActual 0
// #define adressTimeSecondAlarm 4
// #define adressAlarmSong 8
// #define adressManualLuminosity 9
// 
// #define adressAlarmEnable 10
// #define adressSleepDisplay 11
// #define adressDisplayOffTime 12
// #define adressSnoozeMinutes 13
#define adressTimeSecondActual 490
#define adressTimeSecondAlarm 494
#define adressAlarmSong 498
#define adressManualLuminosity 499

#define adressAlarmEnable 500
#define adressSleepDisplay 501
#define adressDisplayOffTime 502
#define adressSnoozeMinutes 503

bool adc_luminosity_updated = false ;
unsigned char old_ADC_luminosity =0;
bool manualLuminosity = false;
bool alarmEnable = true;
bool alarmRunning = false;

unsigned char alarmSong;
unsigned char snoozeMinutes = 1;

bool displayEnable = true;	
unsigned char displayOffTime =1; // number of seconds before auto turn off display
bool sleepDisplay = true; // display switch off automatically after displayOffTime [mn]


unsigned char pwm_OCR=255, ADC_luminosity;//timer0Preset = 0;
unsigned char display[4];
unsigned long timeSecondActual;
unsigned long timeSecondAlarm;
unsigned char timeSecondSinceNoise,tick;
long temperature = 0;
unsigned char adcLow, adcHigh;

//unsigned int timer0count = 0;



void init(){

	/* Define pull-ups and set outputs high */
	/* Define directions for port pins */
	cli();
	/*
	PortB --> DDRB 0b11111111
	0 : segment a (OUTPUT)
	1 : segment b (OUTPUT)
	2 : segment c (OUTPUT)
	3 : segment d (OUTPUT)
	4 : segment e (OUTPUT)
	5 : segment f (OUTPUT)
	6 : segment g (OUTPUT)
	7 : segment DP (OUTPUT)
	PortC --> DDRC 0b0011110x
	0 : Capteur de temprature (IN/OUT)
	1 : Capteur de luminosit (INPUT)
	2 : Anode du digit 1 (OUTPUT)
	3 : Anode du digit 2 (OUTPUT)
	4 : Anode du digit 3 (OUTPUT)
	5 : Anode du digit 4 (OUTPUT)
	6 : Reset (INPUT)
	7 : Inexistant
	PortD --> DDRD 0b00010011
	0 : Sortie vers le haut-parleur (OUTPUT)
	1 : Contrle de lactivation du : (OUTPUT)
	2 : Entre de la base de temps de 1Hz (INPUT)
	3 : Entre du capteur sonore (INPUT)
	4 : Led dindication du rveil (OUTPUT)
	5 : Switch 1 (INPUT)
	6 : Switch 2 (INPUT)
	7 : Switch 3 (INPUT)
*/
	PORTD |= 0b11100000; //enable pullup for input switch PD7,6,5
	DDRB = 0b11111111; 
	DDRC = 0b00111100;
	DDRD = 0b00010011;
/* Insert delay for synchronization*/
	_delay_ms(1);
	init_interrupt();
	sei(); //enable interrupt
	sbi(PORTD,PIND0); // set output to one to switch off speaker (MOSFET P)
	sbi(ADCSRA,ADSC);   // Start ADC Conversion
	readEepromValues();

	if((alarmSong > nbOfSongs) | (alarmSong == 0))
		setEepromValues(false);

	timeSecondSinceNoise = 0;
	//chooseSong();
}

int main(void)
{
	init();
	adjustTime();	
    /* Main loop */
    while (1){	
		if(buttonLeftPushed() & buttonMiddlePushed() & !buttonRightPushed()){
			delay_ms(1000);
			if(buttonLeftPushed() & buttonMiddlePushed() & !buttonRightPushed())
				alarmRoutine(true); // play music		
			
		}
		if(timeSecondActual >=86399){ // check if it's midnight then set time to 0
			timeSecondActual = 0;
			timeSecondSinceNoise = 0;
		}
		if((timeSecondSinceNoise >(displayOffTime)) & sleepDisplay){ // check if the display should turn off
			displayEnable = false;
			//pwm_OCR=255;
		}
		if(checkWakerTime()) // check if it is alarm time
			alarmRoutine(true); // play music
		
		//go to menu if middle button is pushed
		if(buttonMiddlePushed() & !buttonLeftPushed() & !buttonRightPushed())
			menu();
		
		// if the 3 buttons are pushed for more than 1 seconds store the values in eeprom
		// useful to move the clock from one point to the other in the same minute
		if(buttonLeftPushed() & buttonRightPushed() & buttonMiddlePushed()){
			char t = 0;
			while(buttonLeftPushed() & buttonRightPushed() & buttonMiddlePushed()){
				if(t > 5){ // if pressed more than 1 seconds
					displayText("Stor");
					while(buttonLeftPushed() | buttonRightPushed()){blinkDisplay(200,dispNoChange);}
					setEepromValues(true);
				}
				delay_ms(200);
				t++;
			}
		}
		
		if(displayEnable){ // display time-temp or nothing
			adjustLuminosity(true);
	//		displaySeconds();
			if(timeSecondActual%15 == 0) // every 15s display temp for 3s
				tick=0;
			if(tick < 15){
				tick++;
				temperature = ds18b20_gettemp();
				displayTemperature();	
			}else{
				//sendNumberToDigit(ADC_luminosity,true);
				displayTime();
			}
		}else{
			displayNothing();
		}
 		_delay_ms(200);
 	}
}

void menu(){
	
	//char pressed = 0;
	bool goToMenu = false;
	unsigned char choice = 0;
	
	displayText("Al-t"); // display alarm time
	delay_ms(500);
	displayAlarm(); // display the alarm time set
	delay_ms(1500);
	while(buttonMiddlePushed()){ // if still pushed after 2s do to menu
		goToMenu = true;
		blinkDisplay(250,dispNoChange);
	}
	
		
	if(goToMenu){ //main menu
		//pressed = 0;
		while(goToMenu){
			adjustLuminosity(false);
			if(buttonLeftPushed()){ // if going down in menu
				if(choice > 0) // go to the maximum value if less than  the minimum (loop)
					choice--;
				else
					choice = DONE;
				while(buttonLeftPushed()){delay_ms(20);} // wait for button release
			}
			if(buttonRightPushed()){ // if going up in menu
				if(choice < DONE)  // go to minimum value if more than maximum (loop)
					choice++;
				else
					choice = SETHOUR;
				while(buttonRightPushed()){delay_ms(20);} // wait for button release
			}
			displayMenu(choice); // display the selected menu text
			if(buttonMiddlePushed()){ // select the option to change			
				while(buttonMiddlePushed()){blinkDisplay(250,dispNoChange);}
				goToSelectedMenu(choice); // go to the selected submenu
				if(choice == DONE)
					goToMenu = false;
				
			}
		}
	}
}

void sleepDisplayActivation(){
	if(sleepDisplay)
		displayText("ON  ");
	else
		displayText("OFF ");
	bool done = false;
	
	while(!done){
		adjustLuminosity(false);
		if(buttonLeftPushed()){
			displayText("OFF ");
			sleepDisplay = false;
			while(buttonLeftPushed()){delay_ms(200);}
		}
		if(buttonRightPushed()){
			displayText("ON  ");
			sleepDisplay = true;
			while(buttonRightPushed()){delay_ms(200);}
		}
		
		if(buttonMiddlePushed()){
			while(buttonMiddlePushed()){delay_ms(200);}
			if(sleepDisplay){
				while(!done){// set the time before sleep
					adjustLuminosity(false);
					sendNumberToDigit(displayOffTime,true);
					int count = 150;
					while(buttonLeftPushed() & (displayOffTime >1)){
						displayOffTime--;
						sendNumberToDigit(displayOffTime,true);
						
						if(count >10) // increase speed if long press
							count = count -5;
						delay_ms(count);
						
					//	delay_ms(200);
						//while(buttonLeftPushed()){delay_ms(200);}
					}
					while(buttonRightPushed() & (displayOffTime < 240)){
						displayOffTime++;
						sendNumberToDigit(displayOffTime,true);
						if(count >10) // increase speed if long press
							count = count -5;
						delay_ms(count);
						
						//delay_ms(200);
						//while(buttonRightPushed()){delay_ms(200);}
					}
					
					while(buttonMiddlePushed()){
						blinkDisplay(200,dispNoChange);
						done = true;
					}
				}
				EEPROM_write(adressDisplayOffTime,displayOffTime);
				EEPROM_write(adressSleepDisplay,1);
			}else{
				done = true;
				EEPROM_write(adressSleepDisplay,0);
			}
			
			while(buttonMiddlePushed()){
				blinkDisplay(200,dispNoChange);
				done = true;
			}
		}
	}
}

void alarmActivation(){
	if(alarmEnable)
		displayText("ON  ");
	else
		displayText("OFF ");
	bool done = false;
	
	while(!done){
		adjustLuminosity(false);
		if(buttonLeftPushed()){
			displayText("OFF ");
			alarmEnable = false;
			alarmLed(off);
			while(buttonLeftPushed()){delay_ms(200);}
		}
		if(buttonRightPushed()){
			displayText("ON  ");
			alarmEnable = true;
			alarmLed(on);
			while(buttonRightPushed()){delay_ms(200);}
		}
		
		if(buttonMiddlePushed()){
			
			if(alarmEnable)
				EEPROM_write(adressAlarmEnable,1);
			else
				EEPROM_write(adressAlarmEnable,0);
			
			
			while(buttonMiddlePushed()){
				blinkDisplay(200,dispNoChange);
				done = true;
			}
		}
	}
}

void goToSelectedMenu(unsigned char choice){
	
	switch (choice){
		case SETHOUR: adjustTime();
		break;
		case SETALARMTIME: adjustAlarm();
		break;
		case ALARMENABLE: alarmActivation();
		break;
		case SNOOZE: snoozeSetup();
		break;
		case BRIGHTNESS: setBrightnessMode();
		break;
		case SLEEPDISPLAY: sleepDisplayActivation();
		break;
		case SONG : chooseSong();
		break;
		case DONE: displayText("Done");
		break;
		default:displayText("No  ");
	}
	
}

void adjustTime(){
	
	bool setTime = true;
		
	while(setTime){ // if set time is requested
		adjustLuminosity(false);
		int count = 150; // set the adjust speed
		blinkDisplay(30,dispTime);
		
		while(buttonLeftPushed()){ // check if A4 is pushed decrease time by 1 minute
			
			if(timeSecondActual<60)
				timeSecondActual = 86400; // set time to midnight
			timeSecondActual-=60; // decrease by 60 seconds
			
			if(count >10) // increase speed if long press
			count = count -5;
			delay_ms(count);
			displayTime();
		}
		
	
		count = 150; // set the adjust speed
		while(buttonRightPushed()){ // check if A5 is pushed increase time by 1 minute
			
			timeSecondActual+=60; // increase by 60 seconds
			
			if(count >10) // increase speed if long press
			count = count -5;
			delay_ms(count);
			displayTime();
		}
		
		if(buttonMiddlePushed()){ // test if 2 buttons are pushed
			
			timeSecondActual /=60; // round second to 0
			timeSecondActual *=60;
			saveLongInEEprom(timeSecondActual,adressTimeSecondActual);
	
			setTime = false;
			displayText("Set ");
			while (buttonMiddlePushed()){delay_ms(20);}
		}
		
	}
	
}

void snoozeSetup(){
	//bool done = false;
	//int  count;
	bool setSnooze = true;

	while(setSnooze){ // if set time is requested
		//blinkDisplay(100,dispSnooze);
		adjustLuminosity(false);
		
		if(buttonLeftPushed() & (snoozeMinutes>1)) // check if left button is pushed decrease time by 1 minute
			snoozeMinutes-=1; // decrease by 1 minute
		sendNumberToDigit(snoozeMinutes,true);
		_delay_ms(50);	
		int count = 150; // set the adjust speed
		while(buttonLeftPushed()){ // check if left button is pushed decrease time by 1 minute
			
			if(snoozeMinutes>1)
				snoozeMinutes-=1; // decrease by 1 minute
			
			if(count >10) // increase speed if long press
			count = count -5;
			delay_ms(count);
			sendNumberToDigit(snoozeMinutes,true);
		}
		count = 150; // set the adjust speed
		while(buttonRightPushed()){ // check if right button is pushed increase time by 1 minute
			if(snoozeMinutes<30)
				snoozeMinutes+=1; // decrease by 1 minute
			
			if(count >10) // increase speed if long press
				count = count -5;
			delay_ms(count);
			sendNumberToDigit(snoozeMinutes,true);
		}
		
		while (buttonMiddlePushed()){ // test if middle button is pushed
			
			saveLongInEEprom(snoozeMinutes,adressSnoozeMinutes);
			
			setSnooze = false;
			
			displayText("Set ");
			_delay_ms(200);
			while (buttonMiddlePushed()){delay_ms(20);}
		}
		
	}
}

void adjustAlarm(){
	
	bool setAlarm = true;

	while(setAlarm){ // if set time is requested
		blinkDisplay(30,dispAlarmTime);
		adjustLuminosity(false);
			
		int count = 150; // set the adjust speed
		while(buttonLeftPushed()){ // check if left button is pushed decrease time by 1 minute
			
			if(timeSecondAlarm<60)
			timeSecondAlarm = 86400; // set time to midnight
			timeSecondAlarm-=60; // decrease by 60 seconds
			
			if(count >10) // increase speed if long press
			count = count -5;
			delay_ms(count);
			displayAlarm();
		}
		
		count = 150; // set the adjust speed
		while(buttonRightPushed()){ // check if right button is pushed increase time by 1 minute
			
			timeSecondAlarm+=60; // increase by 60 seconds
			
			if(count >10) // increase speed if long press
			count = count -5;
			delay_ms(count);
			displayAlarm();
		}
		
		while (buttonMiddlePushed()){ // test if middle button is pushed
			
			timeSecondAlarm /=60; // round second to 0
			timeSecondAlarm *=60;
			saveLongInEEprom(timeSecondAlarm,adressTimeSecondAlarm);
			displayAlarm();
			setAlarm = false;
			
			displayText("Set ");
			while (buttonMiddlePushed()){delay_ms(20);}	
		}
		
	}
}

// Menu to choose the song
void chooseSong(){
	
	bool done = false;
	displaySelectedSong();

		
	while(!done){
		adjustLuminosity(false);
		if(buttonLeftPushed()){
			if(alarmSong>1)
				alarmSong--;
			else
				alarmSong = nbOfSongs;
			while(buttonLeftPushed()){delay_ms(20);}
		}
		if(buttonRightPushed()){
			if(alarmSong<nbOfSongs)
				alarmSong++;
			else
				alarmSong=1;
			while(buttonRightPushed()){delay_ms(20);}
		}
		displaySelectedSong();
		alarmRoutine(false);
		
		if(buttonMiddlePushed()){ // test if right button is pushed
			EEPROM_write(adressAlarmSong,alarmSong);
			displayText("Set ");
			done = true;
			while (buttonMiddlePushed()){delay_ms(20);}
		}
	}
	
	
}

// Menu to set the brightness mode
void setBrightnessMode(){
	bool done = false;
	if(manualLuminosity)
		displayText("Off ");
	else
		displayText("Auto");
		
	while(!done){
		adjustLuminosity(false);
		if(buttonRightPushed()){ // check if button ^right is pushed
			displayText("Auto");
			manualLuminosity = false;
			while(buttonRightPushed()){delay_ms(200);}
		}
		if(buttonLeftPushed()){ // check if button left is pushed
			displayText("Off ");
			manualLuminosity = true;
			while(buttonLeftPushed()){delay_ms(200);}
		}
		if(buttonMiddlePushed()){ // test if right button is pushed
			if(manualLuminosity)
				EEPROM_write(adressManualLuminosity,1);
			else
				EEPROM_write(adressManualLuminosity,0);
				
			displayText("Set ");
			done = true;
			while (buttonMiddlePushed()){delay_ms(20);}
		}
	}
	
}

//read the ADC value to adapt the brightness of the display
void readADC(){
	
	if(adc_luminosity_updated){
		old_ADC_luminosity = ADC_luminosity;
		adc_luminosity_updated = false;
		ADC_luminosity = adcHigh;
		sbi(ADCSRA,ADSC);   // Start ADC Conversion
	}

}

// Adjust the display and led luminosity by changing the Ouptput compare
// of timer 2 (pwm_OCR set the value of OCR2 in TIMER2_OVF_vect)
void adjustLuminosity(bool manDisable){ // if call from menu disable manual luminosity

	if(manualLuminosity & manDisable){
//adjust luminosity manually
		if(buttonLeftPushed()){ // check if left pushed is pushed decrease luminosity
			if(pwm_OCR<245)
				pwm_OCR+=10;
			else
				pwm_OCR= 255;
			
		}
		if(buttonRightPushed()){ // check if right button is pushed increase luminosity
			if(pwm_OCR>11)
			pwm_OCR-=10;
			else
			pwm_OCR=1;
		}
	}else{
		readADC();
// 	automatic adjust if change more than hysteresis level
		//unsigned char hyst_luminosity = 1;
		if(!manDisable)
			delay_ms(20);//hyst_luminosity=0; 
		if(old_ADC_luminosity - ADC_luminosity!=0){
			if(ADC_luminosity>10){
				if(ADC_luminosity > 20){
					if(ADC_luminosity > 40){
						if(ADC_luminosity > 60){
							if(ADC_luminosity > 80){
								if(ADC_luminosity > 100){
									if(ADC_luminosity > 232){
										pwm_OCR = 1;
									}else{
										pwm_OCR = 21;
									}
								}else
									pwm_OCR = 100;
							}else
								pwm_OCR = 200;
						}else
							pwm_OCR = 220;
					}else
						pwm_OCR = 230;
				}else
					pwm_OCR = 240;
			}else
				pwm_OCR = 255;
		}//end if luminosity value
	}//end if man-auto
}//end function

// Return true if the alarm time is reached
// Check if quick access to alarm time is requested
bool checkWakerTime(){
	if(alarmEnable){
		if((timeSecondAlarm == timeSecondActual)){
			return true;
		}
	}
	// check if quick access to alarm time is requested
	if(buttonLeftPushed() & buttonRightPushed() & !buttonMiddlePushed()){ 
		unsigned char t = 0;
		bool change = true;
		while(buttonLeftPushed() & buttonRightPushed() & !buttonMiddlePushed()){
			if(t > 5){ // if pressed more than 1 seconds
				displayText("Al-t");
				while(buttonLeftPushed() | buttonRightPushed()){blinkDisplay(200,dispNoChange);}
				adjustAlarm(); // adjust alarm time
				change = false;
			}
			delay_ms(200);
			t++;
		}
		while(buttonLeftPushed() | buttonRightPushed()){delay_ms(100);} // wait for release
		if(change)
			alarmEnable = !alarmEnable;
		if(alarmEnable)
			EEPROM_write(adressAlarmEnable,1); // store new value in eeprom
		else{
			EEPROM_write(adressAlarmEnable,0);
			alarmLed(off);
		}
	}

	return false;
}

// Read all the values stored in the eeprom
void readEepromValues(){
	
	timeSecondAlarm = readLongFromEEprom(adressTimeSecondAlarm);
	timeSecondActual = readLongFromEEprom(adressTimeSecondActual);
	alarmSong = EEPROM_read(adressAlarmSong);
	snoozeMinutes = EEPROM_read(adressSnoozeMinutes);
	displayOffTime = EEPROM_read(adressDisplayOffTime);
	if(EEPROM_read(adressSleepDisplay)==1)
	sleepDisplay = true;
	else
	sleepDisplay = false;
	
	if(EEPROM_read(adressAlarmEnable)==1)
	alarmEnable = true;
	else
	alarmEnable = false;
	
	if(EEPROM_read(adressManualLuminosity)==1)
	manualLuminosity = true;
	else
	manualLuminosity = false;
}

// save the actual value or default value in the eeprom
void setEepromValues(bool storeActual){ // store values in eeprom
	
	if(!storeActual){ // set manual value for first the initialization
		timeSecondActual = 57600;
		timeSecondAlarm = 25200;
		alarmSong = 1;
		alarmEnable = false;
		sleepDisplay = true;
		manualLuminosity = false;
		displayOffTime = 10;
		snoozeMinutes = 5;
	}
	saveLongInEEprom(timeSecondActual,adressTimeSecondActual);
	saveLongInEEprom(timeSecondAlarm,adressTimeSecondAlarm);
	EEPROM_write(adressAlarmSong,alarmSong);
	EEPROM_write(adressSnoozeMinutes,snoozeMinutes);
	
	EEPROM_write(adressDisplayOffTime,displayOffTime);
	if(alarmEnable)
	EEPROM_write(adressAlarmEnable,1);
	else
	EEPROM_write(adressAlarmEnable,0);
	
	if(sleepDisplay)
	EEPROM_write(adressSleepDisplay,1);
	else
	EEPROM_write(adressSleepDisplay,0);
	
	if(manualLuminosity)
	EEPROM_write(adressManualLuminosity,1);
	else
	EEPROM_write(adressManualLuminosity,0);
}

// write in eeprom a long in 4 bytes at adress #startAdress
void saveLongInEEprom(unsigned long longToSave, unsigned int startAdress){
	
	unsigned char bytes[4];
	for(unsigned char u = 0;u<4;u++){
		bytes[u]= (longToSave>>(u*8)) & 0xFF;
		EEPROM_write(startAdress+u,bytes[u]);
	}
}

// read in eeprom a long stored at adress #startAdress
unsigned long readLongFromEEprom(unsigned int startAdress){
	
	unsigned long readedLong=0;
	unsigned char bytes[4];
	for(unsigned char u = 4;u>0;u--){
		bytes[u-1]=EEPROM_read(startAdress+u-1);
		readedLong = readedLong | ((long)bytes[u-1]<<((u-1)*8));
	}
	return readedLong;
}

// write in eeprom a byte at adress #uiAdress 
void EEPROM_write(unsigned int uiAddress, unsigned int ucData)
{
	/* Wait for completion of previous write */
	while(EECR & (1<<EEWE));
	/* Set up address and data registers */
	EEAR = uiAddress;
	EEDR = ucData;
	/* Write logical one to EEMWE */
	EECR |= (1<<EEMWE);
	/* Start eeprom write by setting EEWE */
	EECR |= (1<<EEWE);
}

// read in eeprom a byte stored at adress #uiAdress
unsigned char EEPROM_read(unsigned int uiAddress)
{
	/* Wait for completion of previous write */
	while(EECR & (1<<EEWE));
	/* Set up address register */
	EEAR = uiAddress;
	/* Start eeprom read by writing EERE */
	EECR |= (1<<EERE);
	/* Return data from data register */
	return EEDR;
}