/*
 * alarm.h
 *
 * Created: 06.03.2021 09:46:30
 *  Author: Nicolas Turin
 */ 


#ifndef SOUND_H_
#define SOUND_H_

#include "main.h"

// should be 4 characters
#define textAlarm1 "al 1"
#define textAlarm2 "al 2"
#define textAlarm3 "al 3"
#define textAlarm4 "al 4"

#define X0 0 //pause
//	notes OCR1 value
#define	C0 	30581
#define	Db0	28868
#define	D0	27248
#define	Eb0	25707
#define	E0	24272
#define	F0	22904
#define	Gb0	21626
#define	G0	20408
#define	Ab0	19260
#define	LA0	18182
#define	Bb0	17159
#define	B0	16197
#define	C1	15291
#define	Db1	14430
#define	D1	13620
#define	Eb1	12857
#define	E1	12136
#define	F1	11455
#define	Gb1	10811
#define	G1	10204
#define	Ab1	9632
#define	LA1	9091
#define	Bb1	8581
#define	B1	8098
#define	C2	7644
#define	Db2	7215
#define	D2	6810
#define	Eb2	6428
#define	E2	6067
#define	F2	5727
#define	Gb2	5405
#define	G2	5102
#define	Ab2	4816
#define	LA2	4545
#define	Bb2	4290
#define	B2	4050
#define	C3	3822
#define	Db3	3608
#define	D3	3405
#define	Eb3	3214
#define	E3	3034
#define	F3	2864
#define	Gb3	2703
#define	G3	2551
#define	Ab3	2408
#define	LA3	2273
#define	Bb3	2145
#define	B3	2025
#define	C4	1911
#define	Db4	1804
#define	D4	1703
#define	Eb4	1607
#define	E4	1517
#define	F4	1432
#define	Gb4	1351
#define	G4	1276
#define	Ab4	1204
#define	LA4	1136
#define	Bb4	1073
#define	B4	1012
#define	C5	956
#define	Db5	902
#define	D5	851
#define	Eb5	804
#define	E5	758
#define	F5	716
#define	Gb5	676
#define	G5	638
#define	Ab5	602
#define	LA5	568
#define	Bb5	536
#define	B5	506
#define	C6	478
#define	Db6	451
#define	D6	426
#define	Eb6	402
#define	E6	379
#define	F6	358
#define	Gb6	338
#define	G6	319
#define	Ab6	301
#define	LA6	284
#define	Bb6	268
#define	B6	253
#define	C7	239
#define	Db7	225
#define	D7	213
#define	Eb7	201
#define	E7	190
#define	F7	179
#define	Gb7	169
#define	G7	159
#define	Ab7	150
#define	LA7	142
#define	Bb7	134
#define	B7	127
#define	C8	119
#define	Db8	113
#define	D8	106
#define	Eb8	100
// DURATION OF THE NOTES
#define BPM 120    //  you can change this value changing all the others
#define H 2*Q //half 2/4
#define Q 60000/BPM //quarter 1/4
#define E Q/2   //eighth 1/8
#define S Q/4 // sixteenth 1/16
#define W 4*Q // whole 4/4
#define nbOfSongs 4

bool checkHumanIsAlive();
void alarmRoutine(bool);
void playNote(char,int);
void playTone(int,int,bool);
void alarmRun(const unsigned int* ,const unsigned int* ,const unsigned char,bool );

#endif