clear; close all; clc

% Test space
resolution = 100;
x_lim = [-5, 5];
y_lim = [-5, 5];
[x,y] = meshgrid(linspace(x_lim(1), x_lim(2), resolution),linspace(y_lim(1), y_lim(2), resolution));
X = [x(:), y(:)];

% LEGEND %
% 1 -> RBF kernel
% 2 -> Sum/subtraction of 2 RBF kernels
% 3 -> Sum/subtraction of 3 RBF kernels
% 4 -> Homogenous/inhomogeneous polynomial kernel
% 5 -> Sum/subtraction of 2 homogenous/inhomogeneous polynomial kernels
% 6 -> Sum/subtraction of RBF and polynomial kernels
% 7 -> Product of RBF and polynomial kernels
ex = '1';

switch ex
    case '1'
        % Kernel reference point
        X_ref = [0, 0];
        % Kernel width
        sigma = 0.5;
        % Kernel eval
        f = rbf_kernel(X_ref, X, sigma);
    case '2'
        % Kernels reference points
        X_ref = [0, 0; 1, 1];
        % Kernel width
        sigma = 0.5;
        % Kernel eval
        f = rbf_kernel(X_ref(1,:), X, sigma) + rbf_kernel(X_ref(2,:), X, sigma);
    case '3'
        % Kernels centers
        X_ref = [1, 0; 0, 1; -1, 0];
        % Kernel width
        sigma = 0.5;
        % Kernel eval
        f = rbf_kernel(X_ref(1,:), X, sigma) + rbf_kernel(X_ref(2,:), X, sigma) + rbf_kernel(X_ref(3,:), X, sigma);
    case '4'
        % Kernel reference point
        X_ref = [1, 1];
        % Polynomial degree
        degree = 1;
        % Polynomial constant
        shift = 0;
        % Kernel eval
        f = polynomial_kernel(X_ref, X, degree, shift);
    case '5'
        % Kernel reference point
        X_ref = [-1, 0; 0.5, 0.5];
        % Polynomial degree
        degree = 2;
        % Polynomial degree
        shift = 0;
        % Kernel eval
        f = polynomial_kernel(X_ref(1,:), X, degree, shift) + polynomial_kernel(X_ref(2,:), X, degree, shift);
    case '6'
        weights = [1, 10];
        % Kernel reference point
        X_ref = [1, 1; 1.5, 1.5];
        % Polynomial degree
        degree = 1;
        % Polynomial degree
        shift = 0;
        % RBF width
        sigma = 0.5;
        % Kernel eval
        f = weights(1)*polynomial_kernel(X_ref(1,:), X, degree, shift) + weights(2)*rbf_kernel(X_ref(2,:), X, sigma);
    case '7'
        % Kernel reference point
        X_ref = [1, 1; 0, 0];
        % Polynomial degree
        degree = 1;
        % Polynomial degree
        shift = 0;
        % RBF width
        sigma = 0.5;
        % Kernel eval
        f = polynomial_kernel(X_ref(1,:), X, degree, shift) .* rbf_kernel(X_ref(2,:), X, sigma);
end

figure (100)
surf(x,y,reshape(f, resolution, []))

figure (200)
contour(x,y,reshape(f, resolution, []))
axis equal; hold on; colorbar; grid on;
scatter(X_ref(:,1),X_ref(:,2),20,'r','filled')