%% You have to evaluate performance of RVM on 2D Datasets
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%      1) Load 2D Non-Linear Classification Dataset          %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 1a) Generate Concentric Circle Data
clear all;
close all;

num_samples = 500;
dim_samples = 2;
num_classes = 2;

[X,labels]  = ml_circles_data(num_samples,dim_samples,num_classes,'svm');
labels      = ml_2binary(labels)';

% Randomize indices of dataset
rand_idx = randperm(num_samples);
X = X(rand_idx,:);
labels = labels(rand_idx);

% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Concentric Circles Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1b) Generate Checkerboard Data
clear all;
close all;

num_samples_p_quad = 100; % Number of points per quadrant
[X,labels] = ml_checkerboard_data(num_samples_p_quad);

% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Checkerboard Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1c) Load Very Non-linear data

clear all;
close all;
load('very-nonlinear-data')

% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Very Non-Linear Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1d) Load Ripley Dataset

clear all;
close all;

load('rvm-ripley-dataset')
labels      = ml_2binary(labels)';
% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Ripley Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1e) Draw Data with ML_toolbox GUI
clear all; close all; clc;
[X, labels] = ml_draw_data
[N,M] = size(X);
X       = X';
labels  = ml_2binary(labels)';

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                  2) Learn RELEVANCE VECTOR MACHINES                  %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2a) Try RVM on Data

%Set RVM OPTIONS%
clear rvm_options
rvm_options.useBias = true;
rvm_options.kernel_ = 'gauss';
rvm_options.width   = 1;
rvm_options.maxIts  = 100;

% Train RVM Classifier
[predict_labels, model] = rvm_classifier(X, labels , rvm_options, []);

% Plot RVM decision boundary
ml_plot_rvm_boundary( X, labels, model, 'draw');

%% 2b) Do Grid Search on RVM
clear options
% Set Options for RVM Grid Search
options.limits_w   = [0.5, 5]; % Limits of kernel width \sigma
options.steps      = 10;       % Step of parameter grid 
options.K          = 5;        % K-fold CV parameter

% Define a linear grid of sigma
% range_w = linspace(options.limits_w(1), options.limits_w(2), options.steps);
% log_grid = 0;

% Define a logged grid of sigma
range_w = logspace(log10(options.limits_w(1)),log10(options.limits_w(2)),options.steps);
log_grid = 1;

% RVM Params
rvm_options.useBias = true;
rvm_options.kernel_ = 'gauss';
rvm_options.maxIts  = 100;

% Store results
ctest  = cell(options.steps,1);
ctrain = cell(options.steps,1);

disp('Grid search RVM');
disp('...');
num_param = length(range_w);
for i=1:num_param
    disp([num2str(i) '/' num2str(num_param)]);
    
    rvm_options.width   = range_w(i);
    f = @(X,labels,model)rvm_classifier(X, labels, rvm_options, model);
    [test_eval,train_eval] = ml_kcv(X, labels, options.K, f, 'classification',1, 'rvm');
    
    ctest{i}  = test_eval;
    ctrain{i} = train_eval;
    
end

%% Get CV statistics
stats = ml_get_cv_grid_states(ctest,ctrain);

% Plot CV statistics
cv_plot_options              = [];
cv_plot_options.title        = ['RVM ' num2str(options.K) '-fold CV'];
cv_plot_options.param_names  = {'$\sigma$'};
cv_plot_options.param_ranges = range_w;
cv_plot_options.log_grid     = log_grid; 

if exist('hcv','var') && isvalid(hcv), delete(hcv);end
hcv = ml_plot_cv_grid_states(stats,cv_plot_options);

%% 2c) Plot Decision Boundary with 'Optimal' Hyper-parameter
[max_acc,ind]   = max(stats.test.acc.mean(:));
w_opt  = range_w(ind);

%OR

%Manually Choose from Test/Train Accuracy
% w_opt = 2.32;

%Set RVM OPTIONS%
rvm_options.useBias = true;
rvm_options.kernel_ = 'gauss';
rvm_options.width   = w_opt;
rvm_options.maxIts  = 100;

% Train RVM Classifier
[predict_labels, model] = rvm_classifier(X, labels , rvm_options, []);

% Plot RVM decision boundary
ml_plot_rvm_boundary( X, labels, model, 'draw');

