%% You have to evaluate performance of Adaboost on 2D Datasets
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%      1) Load 2D Non-Linear Classification Dataset          %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 1a) Generate Concentric Circle Data
clear all;close all;clc;

num_samples = 500;
dim_samples = 2;
num_classes = 2;

[X,labels]  = ml_circles_data(num_samples,dim_samples,num_classes,'svm');
labels      = ml_2binary(labels)';

% Randomize indices of dataset
rand_idx = randperm(num_samples);
X = X(rand_idx,:);
labels = labels(rand_idx);

% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Concentric Circles Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal


%% 1b) Generate Checkerboard Data
clear all;
close all;

num_samples_p_quad = 100; % Number of points per quadrant
[X,labels] = ml_checkerboard_data(num_samples_p_quad);

% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Checkerboard Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1c) Load Very Non-linear data

clear all;
close all;
load('very-nonlinear-data')

% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Very Non-Linear Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1d) Load Ripley Dataset

clear all;
close all;

load('rvm-ripley-dataset')
labels      = ml_2binary(labels)';
% Plot data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Ripley Dataset';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X,plot_options);
legend('Class 1', 'Class -1')
axis equal

%% 1e) Draw Data with ML_toolbox GUI
clear all; close all; clc;
[X, labels] = ml_draw_data
[N,M] = size(X);
X       = X';
labels  = ml_2binary(labels)';


%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%                  2) Learn ADABOOST Classifier                  %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2a) Ada-boost 
N_weak = 60;
[classestimate,model,D]= adaboost_classifier(X,labels,N_weak,[]);
f                      = @(X)adaboost_classifier(X,[],[],model);

% Plot strong classifier sign[C(x)]
c_options         = [];
plot_data_options = [];

c_options.title   = ['AdaBoost  ' num2str(length(model)) ' weak classifier'];
plot_data_options.weights = ml_scale(D,1,50);

if exist('hc','var') && isvalid(hc), delete(hc);end
hc = ml_plot_classifier(f,X,labels,c_options,plot_data_options);
axis tight
legend('off')

% Plot non-signed value of strong classifier C(x)
options = [];
options.dim = [1,2];
if exist('hc_','var') && isvalid(hc_), delete(hc_);end
hc_ = ml_plot_ada_model(X,labels,model,options);
legend('off')

%% 2b) Grid search AdaBoost with CV
% range of number of weak classifiers (decision stumps) 
% range_weak_c = [1, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100];
range_weak_c = linspace(1,100,10);

% K-fold CV parameter
K = 10;

% Store results
ctest  = cell(length(range_weak_c),1);
ctrain = cell(length(range_weak_c),1);

disp('Grid search AdaBoost');
disp('...');
num_para = length(range_weak_c);
for i=1:num_para
    disp([num2str(i) '/' num2str(num_para)]);
    
    f = @(X,labels,model)adaboost_classifier(X,labels,range_weak_c(i),model);
    [test_eval,train_eval] = ml_kcv(X,labels,K,f, 'classification');
    
    ctest{i}  = test_eval;
    ctrain{i} = train_eval;
    
end

%% Get CV statistics
clear stats
stats = ml_get_cv_grid_states(ctest,ctrain);

% Plot CV statistics
cv_plot_options        = [];
cv_plot_options.title   = [num2str(K) '-fold CV'];
cv_plot_options.param_names  = {'Decision Stumps'};
cv_plot_options.param_ranges = range_weak_c;

if exist('hcv','var') && isvalid(hcv), delete(hcv);end
hcv = ml_plot_cv_grid_states(stats,cv_plot_options);
