%%  Test Various Non-Linear Projection Methods
%    on Various 3D Datasets. 
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%            Load 3D Manifold Learning Dataset                %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 1a) Generate 3D Swiss Roll Dataset
clear all; close all; clc;
% Options
dataset_options                    = [];
dataset_options.numberOfPoints     = 1000;
dataset_options.name               = 'swissroll';
dataset_options.plot               = false;

% Generate dataset
[X, labels, ~, cmap] = ml_generate_manifold_dataset(dataset_options);
X = X'; labels = labels';
[N, M] = size(X);

% Plot original data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.points_size = 30;
plot_options.cmap       = cmap;
plot_options.title      = 'Swiss Roll';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X',plot_options);
axis equal

%% 1b) Generate Peaks Dataset
%%%% 3D Sin/Cos Dataset %%%%%%
clc; clear all; close all;
%Options
dataset_type = '2d-cossine';
[ XY, z, ~ ] = ml_load_regression_datasets( dataset_type , false);
X       = [XY,z*3]'; 
cmap    = z';
[N, M] = size(X);

% Plot data
options             = [];
options.points_size = 15;
options.cmap        = cmap';
options.plot_labels = {'$x_1$','$x_2$','$x_3$'};
options.title       = 'Twin Peaks'; 
if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X',options); hold on;
axis tight

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%            2)  Apply Linear PCA on Dataset                 %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2) Compute PCA with ML_toolbox
options = [];
options.method_name       = 'PCA';
options.nbDimensions      = N; % Number of Eigenvectors to compute.
[proj_PCA_X, mappingPCA]  = ml_projection(X',options);

% Plot PCA projections
plot_options             = [];
plot_options.is_eig      = false;
plot_options.cmap        = cmap;
plot_options.plot_labels = {'$y_1$','$y_2$','$y_3$'};
plot_options.title       = 'Projected data with linear PCA';
if exist('h2','var') && isvalid(h2), delete(h2);end
h2 = ml_plot_data(proj_PCA_X(:,[1 2]),plot_options);

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%            3)  Apply Kernel PCA on Dataset                 %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 3) Compute kernel PCA of Dataset and Check Eigenvalues
% Compute kPCA with ML_toolbox
options = [];
options.method_name        = 'KPCA';  % Choosing kernel-PCA method
options.nbDimensions       = 8;       % Number of Eigenvectors to compute.
options.kernel             = 'gauss'; % Type of Kernel: {'poly', 'gauss'}
options.kpar               = [2];     % Variance for the RBF Kernel
                                      % For 'poly' kpar = [offset degree]
options.norm_K             = true;    % Normalize the Gram Matrix                                 
[proj_KPCA_X, mappingkPCA] = ml_projection(X',options);

% Plot EigenValues to try to find the optimal "p"
if exist('h3a','var') && isvalid(h3a), delete(h3a);end
h3a = ml_plot_eigenvalues(diag(mappingkPCA.L));

% Plot result of Kernel PCA
plot_options              = [];
plot_options.is_eig       = false;
plot_options.cmap         = cmap;
plot_options.plot_labels  = {'$y_1$','$y_2$','$y_3$'};
plot_options.title        = 'Projected data with kernel PCA';
if exist('h3','var') && isvalid(h3), delete(h3);end
h3 = ml_plot_data(proj_KPCA_X(:,[1 2]),plot_options);

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%         4)  Apply Laplacian Eigenmaps on Dataset           %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 4) Compute Laplacian Eigenmap with ML_toolbox
options = [];
options.method_name       = 'Laplacian';
options.nbDimensions      = 4;  % Number of Eigenvectors to compute.
options.neighbors         = 8;  % Number of k-NN for Adjacency Graph
options.sigma             = 2;  % Sigma for Similarity Matrix

try
    [proj_LAP_X, mappingLAP]  = ml_projection(X',options);
catch
    err('Please enter a higher number of neighbors or try different sigma!')
end

% Plot result of Laplacian Eigenmaps Projection
plot_options              = [];
plot_options.is_eig       = false;
plot_options.cmap         = cmap;
plot_options.plot_labels  = {'$y_1$','$y_2$','$y_3$'};
plot_options.title        = 'Projected data with Laplacian Eigenmaps';
if exist('h4','var') && isvalid(h4), delete(h4);end
h4 = ml_plot_data(proj_LAP_X(:,[1 2]),plot_options);

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%         5)  Apply Isometric Mapping on Dataset             %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 5) Compute Isomap with ML_toolbox
options = [];
options.method_name       = 'Isomap';
options.nbDimensions      = 4;        % Number of Eigenvectors to compute.
options.neighbors         = 13;       % Number of k-NN for Adjacency Graph

try
    [proj_ISO_X, mappingISO]  = ml_projection(X',options);
catch
    err('Please enter a higher number of neighbors')
end

%% Plot result of Isometric Mapping Projection
plot_options              = [];
plot_options.is_eig       = false;
plot_options.cmap         = cmap;
plot_options.plot_labels  = {'$y_1$','$y_2$','$y_3$'};
plot_options.title        = 'Projected data with Isometric Mapping';
if exist('h5','var') && isvalid(h5), delete(h5);end
h5 = ml_plot_data(proj_ISO_X(:,[1 2]),plot_options);
