%%  Test Kernel-K-Means on Various Datasets. 
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%          1) Load 2D Dataset for Kernel K-Means             %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 1a) Generate 2D Circles Dataset
clear all; close all; clc;
num_samples = 500;
dim_samples = 2;
num_classes = 2;

[X,labels]  = ml_circles_data(num_samples,dim_samples,num_classes, true);
X = X'; labels = labels';
[N, M] = size(X);

% Plot original data
plot_options            = [];
plot_options.is_eig     = false;
plot_options.labels     = labels;
plot_options.title      = 'Circles Data';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X',plot_options);
axis tight

%% 1b) Draw Data with ML_toolbox GUI
clear all; close all; clc;
ml_draw_data
[N,M] = size(X);

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%      2)  Perform Kernel K_means Clustering Dataset         %%
%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2a) Apply Kernel K-Means on Dataset
clear cluster_options
cluster_options.method_name = 'kernel-kmeans';
cluster_options.K           = 2;
cluster_options.kernel      = 'gauss';
cluster_options.kpar        = [1];
[result_kkmeans]            = ml_clustering(X',cluster_options);

% Computation of F-measure [0,1]
F_proj = ml_Fmeasure(result_kkmeans.labels,labels);
fprintf('F-measure: %f\n',F_proj);

% Plot Decision Boundaries for 2D Data
if exist('h2','var') && isvalid(h2), delete(h2);end
result_kkmeans.title       = sprintf('Kernel K(%d)-Means on Original Data',cluster_options.K);
result_kkmeans.plot_labels = {'$x_1$','$x_2$'};
h2 = ml_plot_class_boundary(X',result_kkmeans);

%% Plot Clustered Data for >2D Data
plot_options             = [];
plot_options.is_eig      = false;
plot_options.points_size = 30;
plot_options.labels      = result_kkmeans.labels;
plot_options.plot_labels = {'$x_1$','$x_2$','$x_3$'};
plot_options.title       = 'Clustered Data on Projections';

if exist('h1','var') && isvalid(h1), delete(h1);end
h1 = ml_plot_data(X',plot_options);

%% 2b) Visualize Isolines of Eigenvectors
iso_plot_options                    = [];
iso_plot_options.xtrain_dim         = [1 2];     % Dimensions of the orignal data to consider when computing the gramm matrix (since we are doing 2D plots, original data might be of higher dimension)
iso_plot_options.eigen_idx          = [1:cluster_options.K];   % Eigenvectors to use.
iso_plot_options.b_plot_data        = true;      % Plot the training data on top of the isolines 
iso_plot_options.labels             = labels;    % Plotted data will be colored according to class label
iso_plot_options.b_plot_colorbar    = true;      % Plot the colorbar.
iso_plot_options.b_plot_surf        = false;     % Plot the isolines as (3d) surface 

% Construct Kernel Data
kernel_data                         = [];
kernel_data.alphas                  = result_kkmeans.eigens;
kernel_data.kernel                  = result_kkmeans.kernel;
kernel_data.kpar                    = result_kkmeans.kpar;
kernel_data.xtrain                  = X';
kernel_data.eigen_values            = result_kkmeans.lambda;

if exist('h_isoline','var') && isvalid(h_isoline), delete(h_isoline);end
[h_isoline,h_eig] = ml_plot_isolines(iso_plot_options,kernel_data);

