function  k = rbf_kernel(x,y,sigma)
%RBF Radial basis function y = exp(-1/ (2*var) * || X - x'||^2)
%
%   input -----------------------------------------------------------------
%
%       o x         : (1 x D), center of the RBF ei: x'
%       
%       o X         : (N x D), set of N samples of dimension D
%
%       o variance  : (1 x 1), standard deviation
%
%   output ----------------------------------------------------------------
%
%       o y         : (N x 1), output of the radial basis function
%
%

X = repmat(x,size(y,1),1);
Y = repelem(y,size(x,1),1);

k = exp(-0.5*sum((X - Y).^2/sigma^2,2));

end

