function k = polynomial_kernel(x,y,degree,shift)
% Polynomial kernel y = (<X,x'> + d)^p
%
%   input -----------------------------------------------------------------
%
%       o x         : (1 x D), center of the RBF ei: x'
%       
%       o X         : (N x D), set of N samples of dimension D
%
%       o d         : (1 x 1), bias 
%
%       o p         : (1 x 1), power of the poylnomial : 1, 2 ,3 , etc..
%
%   output ----------------------------------------------------------------
%
%       o y         : (N x 1), output of the radial basis function
%
%
X = repmat(x,size(y,1),1);
Y = repelem(y,size(x,1),1);

k = ( sum(X .*Y,2) + shift ).^degree;

end

