function k = exponential_kernel(x,y,theta)
% k = exp(-1/ (2*var) * || X - x'||)
%
%   input -----------------------------------------------------------------
%
%       o x         : (M x D), centers of the kernel
%       
%       o y         : (N x D), set of N samples of dimension D
%
%       o sigma  : (1 x 1), standard deviation
%
%   output ----------------------------------------------------------------
%
%       o k         : (N x 1), output of the radial basis function
%
%
X = repmat(x,size(y,1),1);
Y = repelem(y,size(x,1),1);

k = exp(-vecnorm(X-Y,2,2)/(2*theta));
end