clear; close all; clc

% Test space
resolution = 100;
x_lim = [-5, 5];
y_lim = [-5, 5];
[x,y] = meshgrid(linspace(x_lim(1), x_lim(2), resolution),linspace(y_lim(1), y_lim(2), resolution));
X = [x(:), y(:)];

% Sample points
X_ref = [1, 0; 0, 1; -1, 0];

% Kernel
kernel = 'rbf_kernel';
k = str2func(kernel);

% Kernel params
sigma = 0.5;
degree = 1;
shift = 0;

if strcmp(kernel,'rbf_kernel') || strcmp(kernel,'exponential_kernel ') || strcmp(kernel,'laplace_kernel')
    k = @(x,y) k(x,y,sigma);
elseif strcmp(kernel,'polynomial_kernel')
    k = @(x,y) k(x,y,degree,shift);
end 

% Gram matrix
K = reshape(k(X_ref, X_ref), size(X_ref,1), []);

% Centering matrix
m = size(X_ref,1);
column_sums = sum(K,1) / m;
total_sum = sum(column_sums, 2) / m;
C = repmat(column_sums, m, 1, 1);
K_centered = K - C - permute(C, [2,1,3]);
K_centered = K_centered + total_sum;

% Eigenvalue decomposition
[V,D] = eigs(K_centered);

% Eigenfunctions
psi1 = V(:,1)'*reshape(k(X_ref,X), size(X_ref,1), []);
psi2 = V(:,2)'*reshape(k(X_ref,X), size(X_ref,1), []);
psi3 = V(:,3)'*reshape(k(X_ref,X), size(X_ref,1), []);

% Plot gram matrix
figure (100)
pcolor([K, zeros(size(K, 1), 1); zeros(1, size(K, 2) + 1)])
title('Gram matrix');
axis image
axis ij
colorbar

% Plot centered gram matrix
figure (200)
pcolor([K_centered, zeros(size(K_centered, 1), 1); zeros(1, size(K_centered, 2) + 1)])
title('Centered Gram matrix');
axis image
axis ij
colorbar
 
figure (300)
contourf(x,y,reshape(psi1, resolution, []))
axis equal; hold on; colorbar; grid on;
scatter(X_ref(:,1),X_ref(:,2),20,'r','filled')
title('First eigenfunction');

figure (400)
contourf(x,y,reshape(psi2, resolution, []))
axis equal; hold on; colorbar; grid on;
scatter(X_ref(:,1),X_ref(:,2),20,'r','filled')
title('Second eigenfunction');

figure (500)
contourf(x,y,reshape(psi3, resolution, []))
axis equal; hold on; colorbar; grid on;
scatter(X_ref(:,1),X_ref(:,2),20,'r','filled')
title('Third eigenfunction');