'''
Advanced Machine Learning
2020 - Spring

LASA @ EPFL
http://lasa.epfl.ch/

Course Material
'''

import numpy as np
import matplotlib.pyplot as plt

# Custom Functions
from KernelRidgeRegression import KernelRidgeRegression
from PolynomialExpertToyData import PolynomialExpertToyData
from GetTrainValidateTest import GetTrainValidateTest

# Python Script for Ridge Regression
Target, PHI, W, X = PolynomialExpertToyData()

# Labels should be from 1,.,K
# Target = sin(X)
RegulationTerm = 10
NumberSamples = Target.shape[0]

#Number of Training Samples
NumberTraining = np.floor(NumberSamples*0.01)

#Number Validation Samples
NumberValidation = np.floor(NumberSamples*0.05)

#Number of testing Samples
NumberTesting = np.floor(NumberSamples*0.01)

# partition data into training validation data 
Train, Validation, Test = GetTrainValidateTest(NumberSamples, NumberTraining, NumberValidation, NumberTesting)

# x_train = np.array([[-2.76, -1.78, -1.51, -0.26,  0.51,  1.41,  1.9 ,  2.06,  3.73, 3.84]]).T
# target = np.array([[38.41086058, 19.1889862 , 14.90746124,  0.75533533, -3.27359483, -3.50337849, -1.58525506, -0.63608875, 18.3494864 , 20.19342342]]).T
# Paramter = [0.9] # two parameters for polynomial kernel
# KernelRegression = KernelRidgeRegression('rbf', x_train, Paramter, target, 1)
# x_vali = np.array([[-4.84, -4.29, -3.86, -3.63, -0.7 ,  0.25,  0.92,  1.31,  3.54, 4.31]]).T
# Out = KernelRegression.KernelPrediction(x_vali)
# import pdb; pdb.set_trace() ## DEBUG ##

         
#Create a KernelRidgeRegressio object
plt.subplot(2, 1, 1)
plt.subplots_adjust(hspace = 0.4)
Paramter = [1, 2] # two parameters for polynomial kernel
KernelRegression = KernelRidgeRegression('poly', X[Train], Paramter, Target[Train], 1)
Out = KernelRegression.KernelPrediction(X[Validation, :])

plt.plot(X[Validation], Out, label='Output of Model Using Validation Data')
plt.plot(X[Train], Target[Train], 'ro', label='Training Samples')
plt.legend()
plt.title('Results with Polynomial Kernel')

plt.subplot(2, 1, 2)
Paramter = [0.9] # one parameter for rbf kernel
KernelRegression = KernelRidgeRegression('rbf', X[Train], Paramter, Target[Train], 1)
Out = KernelRegression.KernelPrediction( X[Validation])

plt.plot(X[Validation], Out, label='Output of Model Using Validation Data')
plt.plot(X[Train], Target[Train], 'ro', label='Training Samples')
plt.legend()
plt.title('Results with RBF kernel')

plt.ion()
plt.show()
