import numpy as np

def PolynomialExpertToyData():
    #This Function generates some polynomial toy data 
    # INPUT
    #
    #Output
    # PHI: N x M array representing N data points of M dimensions that consist of some nonlinear
    # transformation of the array X is this case a second order polinomal  
    # X:N x D array representing N datapoints of D dimensions 
    # W:array Representing the number of parameters, each column represents the parameters for a 
    # different expert, analogues to the parameters in linear regression
    
    # Target: target data
    val_range = 5
    z = np.arange(-val_range, val_range, 0.01)
       
    NumberSamples = z.shape[0]
    
    # Generate uniform data for form -XXX to XXX
    X = z.T.reshape(-1, 1)

    # Number of samples
    M = X.shape[0]
    N = X.shape[1]

    # Parameters to make data linearly separable

    # Generate lables  sample data
    Lables = np.ones((M, 1))
    
    PHI = -np.ones((M, 3))
    PHI[:, 1] = -3*X[:, 0]
    PHI[:, 2] = X[:, 0]**2

    # Make some data with nice parmeters
    W = np.zeros((3, 1))
    W[:, 0] = [1, 2, 3]

    # Generate some target data
    # noise standard deviation
    Nsd = 0.01
    
    Target = PHI.dot(W) + Nsd*np.random.randn(NumberSamples, 1)

    return Target, PHI, W, X

