import numpy as np

class KernelRidgeRegression():
    # KernelRidgeRegression: This function used to create the
    # function Kernel Ridge Regression involves inverting
    # a large matrix, therefore in this code after inputting
    # the kernel, kernel parameters and training data in object is created

    def __init__(self, ker, X, parameters, Target, RegulationTerm):
    # def KernelRegression = KernelRidgeRegression(ker, X, parameters, Target, RegulationTerm):
        #       ker: 'lin','poly','rbf','sam'
        #       X: data matrix with training samples in rows and features in columns
        #parameters:
              #If RBF kernel or sam kernel must be one value 
              #sigma: width of the RBF kernel

             # for polynomial kernel 'poly' the paramters are in the
             # form  parameters=[b a]
             #       b:     bias in the linear and polinomial kernel
             #       d:     degree in the polynomial kernel

             #Linear kernels 'lin' parameters=b
             #       b:     bias in the linear and polinomial kernel
        #Target:row vector of continuous values to be predicted

        # #K:Gram matrix, each element corresponds to the kernel of two feature vectors

        # if (strcmp(ker,'rbf')||strcmp(ker,'sam')):
        if ker=='rbf' or ker=='sam':
            if len(parameters)!=1:
                raise('Error: RBF kernel and Sam kennel only needs one parameter') 
            b = 1
            d = 1
            sigma = parameters
            K = kernelmatrix(ker, X.T, X.T, sigma, b, d)

        elif ker == 'poly':
            if len(parameters) != 2:
                raise('Error: polynomial kernels need two parameters') 

            sigma = 1
            b = parameters[0]
            d = parameters[1]
            K = kernelmatrix(ker, X.T, X.T, sigma, b, d)

        elif ker=='lin':
            if len(parameters) != 2:
                raise('Error: Linear kernels only need one parameter') 

            sigma = 1
            d = 1     
            b = parameters[0]

            K = kernelmatrix(ker, X.T, X.T, sigma, b, d)
        else:
            raise ValueError("Unkown kernerl matrix <<{}>>".format(ker))
        #Regulation matrix
        RegularizationMatrix= np.eye(K.shape[0])

        #Name of kernel
        self.Kernel = ker
        
        #store Parameters
        self.Parameters = parameters
        
        #Store training parameters
        self.TrainingSamples = X.T
        
        #This is the vector of  parameters (K+labda I)^-1 Targets
        self.Train = (np.linalg.pinv(K + RegulationTerm*RegularizationMatrix)).dot(Target)
        
        self.Dummy = [sigma, b, d]

    def KernelPrediction(self, X):
        # This is a matrix where each index corresponds the Kernel between the
        # training samples and the samples you world like a preddication for
        # each rowe  eorresponds to a training sample and each column corresponds
        # to a sample that you would like a prediction for
        Kt = kernelmatrix(self.Kernel, self.TrainingSamples, X.T, self.Dummy[0], self.Dummy[1], self.Dummy[2])
        
        Prediction = Kt.T.dot(self.Train)

        return Prediction


def kernelmatrix(ker, X, X2=None, sigma=None, b=None, d=None):
    # With Fast Computation of the RBF kernel matrix
    # To speed up the computation, we exploit a decomposition of the Euclidean distance (norm)
    #
    # Inputs:
    #       ker:    'lin','poly','rbf','sam'
    #       X:      data matrix with training samples in rows and features in columns
    #       X2:     data matrix with test samples in rows and features in columns
    #       sigma: width of the RBF kernel
    #       b:     bias in the linear and polinomial kernel
    #       d:     degree in the polynomial kernel
    #
    # Output:
    #       K: kernel matrix

    if (not sigma is None) and isinstance(sigma, list):
        sigma = sigma[0]

    if ker=='lin':
        if not X2 is None:
            K = X.T.dot(X2)
        else:
            K = X.T.dot(X)

    elif ker=='poly':
        if not X2 is None:
            K = (X.T.dot(X2) + b)**d
        else:
            K = (X.T.dot(X) + b)**d

    elif ker=='rbf':
        n1sq = np.sum(X**2, axis=0)
        n1 = X.shape[1]

        if X2 is None:
            D = (np.ones(n1,1)*n1sq).T + np.ones(n1, 1)*n1sq - 2*X.T.dot(X)
        else:
            n2sq = np.sum(X2**2, axis=0)
            n2 = X2.shape[1]
            D = (np.ones((n2,1))*n1sq).T + np.ones((n1, 1))*n2sq - 2*X.T.dot(X2)

        K = np.exp(-D/(2*sigma**2))
        
    elif ker=='sam':
        if not X2 is None:
            D = X.T.dot(X2)
        else:
            D = X.T.dot(X)
        K = np.exp(-np.arccos(D)**2/(2*sigma^2))

    else:
        raise('Unsupported kernel <<{}>>'.format(ker))

    return K

