import numpy as np

def GetTrainValidateTest(NumberSamples, NumberTraining, NumberValidation, NumberTesting):
    # This function randomly partitions data into training, validation
    # and testing data using Cross Validation.
    # partitioning data in this manner is commonly used for determining 
    # the performance of algorithms with free parameters.
    # Training data is commonly used to train the system, the optimum
    # value for the free parameters are determined using validation data.
    # Finally the results of the algorithm determined using testing data.
    # This function is different than Matlab in that you enter the number
    # of elements for each set
    # Input
    #    NumberSamples: number of samples in your data set
    #    NumberTraining: number of training examples
    #    NumberValidation: number of validation examples
    #    NumberTesting: number of test examples
    #     such that :NumberSamples> NumberTraining> NumberValidation>NumberTesting
    # Output
    #    Train: Logical index column vectors for training data
    #    Validation:  Logical index column vectors for validation data
    #    Test:  Logical index column vectors for testing data

    # Initialize ouput variables  
    Train = np.zeros(NumberSamples, dtype=bool)
    Validation = np.zeros(NumberSamples, dtype=bool)
    Test = np.zeros(NumberSamples, dtype=bool)

    # Proportion of training data
    TrainProportion = (1.0-NumberTraining/NumberSamples)
    
    # Partition data into training and other, then partition Other
    # into validation and testing data, other is just a dummy variable
    # Other = { validation, test}
    Train, Othere = crossvalind('HoldOut', NumberSamples, TrainProportion)

    # Index of data points in other
    IndexOthere = np.arange(NumberSamples)[Othere]
    
    # Number of data points used for training and testing
    SizeOthere = len(IndexOthere)
    
    # Proportion of data in the set other used in validation
    ValidationProportion = NumberTesting/NumberValidation
    
    # Partition into Validation data and testing data
    ValidationDummy, TestDummy = crossvalind('HoldOut', SizeOthere, ValidationProportion)

    #logical index vectors for validation data
    Validation[IndexOthere[ValidationDummy]] = True

    # logical index vectors for test data
    Test[IndexOthere[TestDummy]] = True
    # Validation = logical(Validation)
    # Test = logical(Test)

    return Train, Validation, Test


def crossvalind(type_split, n_points, proportion_split):
    ''' MATLAB stile split function for crossvalidation. '''
    num_split = int(n_points*proportion_split)
    
    if type_split=='HoldOut':
        test_ind = np.zeros(n_points, dtype=bool)
        test_ind[:num_split] = True
        np.random.shuffle(test_ind)
        
        train_ind = np.logical_not(test_ind)
    return train_ind, test_ind
    
