clear all; close all; clc;

[Target,PHI,W,X] = PolynomialExpertToyData();
%Labels  should be from 1,.,K
%Target = sin(X);
RegulationTerm=10;

NumberSamples=length(Target);
%Number of Training Samples
NumberTraining=floor(NumberSamples*0.01);
%Number Validation Samples
NumberValidation =floor(NumberSamples*0.05);
%Number of testing Samples
NumberTesting=floor(NumberSamples*0.01);
% partition data into training validation data 
[ Train,Validation,Test] = GetTrainValidateTest(NumberSamples,NumberTraining,NumberValidation,NumberTesting);

x_train = [-2.76, -1.78, -1.51, -0.26,  0.51,  1.41,  1.9 ,  2.06,  3.73, 3.84]';
target = [38.41086058, 19.1889862 , 14.90746124,  0.75533533, -3.27359483, -3.50337849, -1.58525506, -0.63608875, 18.3494864 , 20.19342342]';
Paramter = [0.9];
KernelRegression = KernelRidgeRegression(['rbf'], x_train, Paramter, target, 1);
x_vali = [-4.84, -4.29, -3.86, -3.63, -0.7 ,  0.25,  0.92,  1.31,  3.54, 4.31]';
Out = KernelPrediction(KernelRegression, x_vali);

%Create a KernelRidgeRegressio object  
figure(1); subplot(2,1,1); hold on;
Paramter=[1 2]; % two parameters for polynomial kernel
KernelRegression =KernelRidgeRegression(['poly'],X(Train),Paramter,Target(Train),1);

Out=KernelPrediction(KernelRegression, X(Validation));
plot(X(Validation),Out,'LineWidth',4)
plot(X(Train),Target(Train),'ro','LineWidth', 4)
legend('Output of Model Using Validation Data ','Training Samples')
title('Results with P   olynomial Kernel')

subplot(2,1,2); hold on;
Paramter=[0.9] % one parameter for rbf kernel
KernelRegression =KernelRidgeRegression(['rbf'],X(Train),Paramter,Target(Train),1);
Out=KernelPrediction(KernelRegression ,X(Validation));
plot(X(Validation),Out,'LineWidth',4)

plot(X(Train),Target(Train),'ro','LineWidth', 4)
%hold off
legend('Output of Model Using Validation Data ','Training Samples')
title('Results with RBF kernel')

