%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Exercise Script for  Chapter 1 of:                                      %
% "Robots that can learn and adapt" by Billard, Mirrazavi and Figueroa.   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright (C) 2020 Learning Algorithms and Systems Laboratory,          %
% EPFL, Switzerland                                                       %
% Author:  Alberic de Lajarte                                             %
% email:   alberic.lajarte@epfl.ch                                        %
% website: http://lasa.epfl.ch                                            %
%                                                                         %
% Permission is granted to copy, distribute, and/or modify this program   %
% under the terms of the GNU General Public License, version 2 or any     %
% later version published by the Free Software Foundation.                %
%                                                                         %
% This program is distributed in the hope that it will be useful, but     %
% WITHOUT ANY WARRANTY; without even the implied warranty of              %
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General%
% Public License for more details                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Question 1: Compute closed-form trajectory  %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear; close all; clc;
filepath = fileparts(which('chp1_ex1_1_solution.m'));
addpath(genpath(fullfile(filepath, '..', '..', 'libraries', 'book-robot-simulation')));

% Define time vector
time = linspace(0, 5, 50);
% Create robot from the custom RobotisWrapper class
robot = RobotisWrapper();

% Define initial position and target position by sampling two points from
% the workspace of the robot. 
% If you want to manually set them, make sure they are in the workspace,
% and use column vector notation.
initialPosition = robot.sampleRandomPosition();
targetPosition = robot.sampleRandomPosition();

% Compute trajectory based on third order polynomial
maxDeviation = 0.1; % Maximal deviation from the straight line between initial and target position
cartesianTrajectory = nan(3, length(time));
for i=1:3 % For each dimension X, Y, Z
    % Create trajectory with 4 waypoints

    traj4 = linspace(initialPosition(i), targetPosition(i), 4);

    % Disturb the intermediate waypoints with a random number from the
    % uniform distrubution [-max_deviation, min_deviation]
    traj4(2:3) = traj4(2:3) - maxDeviation + 2*maxDeviation*rand(1, 2);
    
    % Fit a polynomial of order 3 for the trajectory with 4 waypoints and
    % evaluate it on the whole time vector
    p = polyfit(linspace(time(1), time(end), 4), traj4, 3);
    cartesianTrajectory(i,:) = polyval(p, time);
end

% Plot resulting trajectory
figure;
plot3(cartesianTrajectory(1,:), cartesianTrajectory(2,:), cartesianTrajectory(3,:))
axis equal; grid on;
xlabel('X [m]'); ylabel('Y [m]'); zlabel('Z [m]');
title('Closed-form time-dependent trajectory based on third-order polynomial');
legend('Trajectory');
disp("Press space to continue..."); pause();
close;

% Animate trajectory with robot
jointTrajectory = robot.computeInverseKinematics(cartesianTrajectory);
robot.animateTrajectory(jointTrajectory, cartesianTrajectory, targetPosition, 'Polynomial trajectory');
