import platform

# Settings CAN

# THIS PARAM CAN BE OVERRIDEN BY THE GUI, check control_comunication.py
IS_LINUX = platform.system() == "Linux"
SERIAL_CHANNEL = '/dev/ttyACM0' if IS_LINUX else 'COM1'
TEMP_FILE_PARAM = 'uDelta_temp.json'
LOG_FILE = "./logfile.asc"

# Settings GUI
REFRESH_RATE = 0.03 # milliseconds
SNAPSHOT_TIME_RANGE = 10 # seconds


# Settings DELTA
Sb = 125  # Base equilateral triangle side (Incircle radius : 0.125m)
Sp = 25 # Platform equilateral triangle side (Circumcircle radius : 0.125m)
L = 91   #Upper arms length
l = 166   #Lower arms parallelogram length

# Default value
DEFAULT_X_TARGET = 0.0
DEFAULT_Y_TARGET = 0.0
DEFAULT_Z_TARGET = -250.0
DEFAULT_ACCELERATION = 10_000
DEFAULT_DECCELERATION = 10_000
DEFAULT_SPEED = 5_000
DEFAULT_KP = 0
DEFAULT_KI = 0
DEFAULT_KD = 0
DEFAULT_ARW = 3000.0
DEFAULT_ANGLE = 0.0
PLOT = True

# Min / Max value
X_MAX = 55
X_MIN = -55
Y_MAX = 55
Y_MIN = -55
Z_MAX = -210
Z_MIN = -250
THETA_MIN = 0
THETA_MAX = 120
ACC_MAX = 10_000
ACC_MIN = 0
DCC_MAX = 10_000
DCC_MIN = 0
V_MAX = 5_000
V_MIN = 0
KP_MAX = 200
KP_MIN = 0
KI_MAX = 200
KI_MIN = 0
KD_MAX = 10
KD_MIN = 0

LIST_POINT = [
    [0.0,0.0,-250],
    [50,50,-220],
    [50,-50,-220],
    [-50,-50,-220],
    [-50,50,-220],
    [50,50,-220],
    [50,-50,-220],
    [-50,-50,-220],
    [-50,50,-220],
    [50,50,-220],
    [50,-50,-220],
    [-50,-50,-220],
    [-50,50,-220]
]