import tkinter as tk
from tkinter import ttk

import matplotlib.pyplot as plt 
from matplotlib.backends.backend_tkagg import FigureCanvasTkAgg
import numpy as np
from ControllerWithGUIMicroDelta.settings import *
from ControllerWithGUIMicroDelta.gui.value_plot import value_plot

SAMPLE_MAX = 50

class motors_plot():
    def __init__(self, master_window, posx, posy) -> None:
        self.window = master_window
        self.value_plot = value_plot()
        #self.fig = plt.Figure()
        #self.axis = [self.fig.add_subplot(211), self.fig.add_subplot(212)]
        self.fig, (self.ax1, self.ax2) = plt.subplots(2,1)
        line1, = self.ax1.plot([])
        line2, = self.ax1.plot([])
        line3, = self.ax1.plot([])
        line4, = self.ax2.plot([])
        line5, = self.ax2.plot([])
        line6, = self.ax2.plot([])
        self.line = [line1, line2, line3, line4, line5, line6]
        self.time = []
        self.count = 0
        self.ax1.set_xlim(0,50)
        self.ax1.set_ylim(0,120)
        self.ax2.set_xlim(0,50)
        self.ax2.set_ylim(-260,60)
        self.time2 = np.linspace(0,50,num=50)

        self.plotChoice = 0
        self.canvas = FigureCanvasTkAgg(self.fig, master=self.window) 
        self.canvas.get_tk_widget().grid(column=posx, row=posy, columnspan=6, padx=2,pady=2)

    def animate(self, i,checkButtons): 
        # Value from the motor
        for motor in self.value_plot.motors_value:
            motor.position_plot.append(motor.position)
            motor.position_plot = motor.position_plot[-SAMPLE_MAX:]
            # motor.current_plot.append(motor.current)
            # motor.current_plot = motor.current_plot[-SAMPLE_MAX:]
            # motor.timePosition_plot.append(motor.timePosition)
            # motor.timePosition_plot = motor.timePosition_plot[-SAMPLE_MAX:]
            # motor.timeVelocityCurrent_plot.append(motor.timeVelocityCurrent)
            # motor.timeVelocityCurrent_plot = motor.timeVelocityCurrent_plot[-SAMPLE_MAX:]
        
        # Value XYZ from the Delta
        self.value_plot.x_plot.append(self.value_plot.x)
        self.value_plot.x_plot = self.value_plot.x_plot[-SAMPLE_MAX:]
        self.value_plot.y_plot.append(self.value_plot.y)
        self.value_plot.y_plot = self.value_plot.y_plot[-SAMPLE_MAX:]
        self.value_plot.z_plot.append(self.value_plot.z)
        self.value_plot.z_plot = self.value_plot.z_plot[-SAMPLE_MAX:]

        # self.time.append(self.count)
        # self.time = self.time[-SAMPLE_MAX:]
        # self.count +=1

        for i, checkButton in enumerate(checkButtons):
            if i < 3:
                if checkButton.get():
                    self.line[i].set_data(self.time2[-len(self.value_plot.motors_value[i].position_plot):], self.value_plot.motors_value[i].position_plot)
                else:
                    self.line[i].set_data([],[])
            else:
                if i == 3:
                    if checkButton.get():
                        self.line[i].set_data(self.time2[-len(self.value_plot.x_plot):], self.value_plot.x_plot)
                    else:
                        self.line[i].set_data([],[])
                elif i == 4:
                    if checkButton.get():
                        self.line[i].set_data(self.time2[-len(self.value_plot.y_plot):], self.value_plot.y_plot)
                    else:
                        self.line[i].set_data([],[])
                elif i == 5:
                    if checkButton.get():
                        self.line[i].set_data(self.time2[-len(self.value_plot.z_plot):], self.value_plot.z_plot)
                    else:
                        self.line[i].set_data([],[])
            
        # if (checkButtons[3]| checkButtons[4] ) & checkButtons[5] :
        #     self.ax2.set_ylim(Z_MIN-5, X_MAX+5)
        # print(max(self.value_plot.motors_value[0].position_plot))
        # print(max(self.value_plot.motors_value[1].position_plot))
        # print(max(self.value_plot.motors_value[1].position_plot + self.value_plot.motors_value[0].position_plot))

        return self.line

        # self.axis[0].clear()
        # self.axis[0].grid()
        # self.axis[1].clear()
        # self.axis[1].grid()
        
        # if checkButtons[0].get():
        #     #self.axis[0].plot(self.value_plot.motors_value[0].timePosition_plot,self.value_plot.motors_value[0].position_plot)
        #     self.axis[0].plot(self.value_plot.motors_value[0].position_plot)
        #     self.axis[0].set_ylabel("Angle [Degree]")
        #     #self.axis[0].set_xlabel("Time [?]")
        # if checkButtons[1].get():
        #     #self.axis[0].plot(self.value_plot.motors_value[1].timePosition_plot,self.value_plot.motors_value[1].position_plot)
        #     self.axis[0].plot(self.value_plot.motors_value[1].position_plot)
        #     self.axis[0].set_ylabel("Angle [Degree]")
        #     #self.axis[0].set_xlabel("Time [?]")
        # if checkButtons[2].get():
        #     #self.axis[0].plot(self.value_plot.motors_value[2].timePosition_plot,self.value_plot.motors_value[2].position_plot)
        #     self.axis[0].plot(self.value_plot.motors_value[2].position_plot)
        #     self.axis[0].set_ylabel("Angle [Degree]")
        #     #self.axis[0].set_xlabel("Time [?]")
        # if checkButtons[3].get():
        #     self.axis[1].plot(self.value_plot.x_plot)
        #     self.axis[1].set_ylabel("Position [mm]")
        #     #self.axis[0].set_xlabel("Time [?]")
        # if checkButtons[4].get():
        #     self.axis[1].plot(self.value_plot.y_plot)
        #     self.axis[1].set_ylabel("Position [mm]")
        #     #self.axis[0].set_xlabel("Time [?]")
        # if checkButtons[5].get():
        #     self.axis[1].plot(self.value_plot.z_plot)
        #     self.axis[1].set_ylabel("Position [mm]")
        #      #self.axis[0].set_xlabel("Time [?]")