from ControllerWithGUIMicroDelta.gui.motors_plot import motors_plot
from ControllerWithGUIMicroDelta.settings import *

import tkinter as tk
from tkinter import ttk
import sv_ttk

from matplotlib.animation import FuncAnimation
import os

class gui(tk.Tk):
    def __init__(self) -> None:
        super().__init__()
        self.title("TP uDelta Controller")
        self.trajectoryChoice = tk.IntVar(value=0)
        self.plotChoice = tk.IntVar(value=0)
        self.robotStateTK = tk.StringVar(value="none")
        self.choiceAngle = tk.IntVar(value=0)
        self.current_snapshot_path = tk.StringVar(value="No path selected")
        self.want_snapshot = False
        self.robotState = "none"
        self.xTarget = DEFAULT_X_TARGET
        self.yTarget = DEFAULT_Y_TARGET
        self.zTarget = DEFAULT_Z_TARGET
        self.max_speed = DEFAULT_SPEED
        self.max_acc = DEFAULT_ACCELERATION
        self.max_dec = DEFAULT_DECCELERATION
        self.thetaTarget = [DEFAULT_ANGLE,DEFAULT_ANGLE,DEFAULT_ANGLE]
        self.PID = {'kp' : DEFAULT_KP,
                    'ki' : DEFAULT_KI,
                    'kd' : DEFAULT_KD}
        self.good = {'target' : [False, False, False], 
                     'trajectory' : [False, False, False],
                     'PID': [False, False, False],
                     'angle': [False, False, False],
                     'angle2': [False, True, True]}
        self.minValue = {'target' : [X_MIN, Y_MIN, Z_MIN], 
                         'trajectory' : [V_MIN, ACC_MIN, DCC_MIN],
                         'PID': [KP_MIN, KI_MIN, KD_MIN],
                         'angle': [THETA_MIN, THETA_MIN, THETA_MIN],
                         'angle2': [THETA_MIN, THETA_MIN, THETA_MIN]}
        self.maxValue = {'target' : [X_MAX, Y_MAX, Z_MAX], 
                         'trajectory' : [V_MAX, ACC_MAX, DCC_MAX],
                         'PID': [KP_MAX, KI_MAX, KD_MAX],
                         'angle': [THETA_MAX, THETA_MAX, THETA_MAX],
                         'angle2': [THETA_MAX, THETA_MAX, THETA_MAX]}
        self.sendButton = {}
        self.targetAngle = 0.0
        self.newTarget = False
        self.newTargetAngle = False
        self.newParams = False
        self.plot = PLOT
        try:
            # Check if file exists before loading
            if os.path.isfile("delta.png"):
                self.img = tk.PhotoImage(file="delta.png")
                self.simg = self.img.subsample(2, 2)
            else:
                # Create a blank image if file not found
                self.img = tk.PhotoImage(width=200, height=200)
                self.simg = self.img
                print("Warning: delta.png not found, using blank image instead")
        except Exception as e:
            # Fallback for any image loading errors
            self.img = tk.PhotoImage(width=200, height=200)
            self.simg = self.img
            print(f"Error loading image: {e}")

        # Header
        #ttk.Label(self,text="Micro Delta by NN",font=("Helvetica",24)).grid(column=0, row=0, columnspan=3, padx=5,pady=5)
        ttk.Label(self,text="Information Delta",font=("Helvetica",20)).grid(column=0, row=2, columnspan=2, padx=5,pady=5)
        ttk.Label(self,text="Plot",font=("Helvetica",20)).grid(column=2, row=2, columnspan=1, padx=5,pady=5)

        # Principal Frame and Position
        homingFrame = ttk.Frame(self)
        homingFrame.grid(column=0, row=1, columnspan=3)

        statusRobotFrame = ttk.Frame(self)
        statusRobotFrame.grid(column=0, row=3, rowspan=2, sticky= tk.N)

        self.targetDeltaFrame = ttk.Frame(self)
        self.targetDeltaFrame.grid(column=1,row=3, sticky= tk.N)

        self.targetMotorFrame = ttk.Frame(self)
        self.targetMotorFrame.grid(column=1,row=4, sticky= tk.N)

        self.trajectoryParamsFrame = ttk.Frame(self)
        self.trajectoryParamsFrame.grid(column=0, row=5, sticky= tk.N)

        self.pidParamsFrame = ttk.Frame(self)
        self.pidParamsFrame.grid(column=1, row=5, sticky= tk.N)

        plotFrame = ttk.Frame(self)
        plotFrame.grid(column=2,row=3, rowspan=3, sticky= tk.N)

        messageFrame = ttk.Frame(self)
        messageFrame.grid(column=0,row=6, columnspan=3, sticky= tk.W)

        self.frame_mode(homingFrame)
        self.frame_info_trajectory(self.targetDeltaFrame)
        self.frame_status(statusRobotFrame)
        self.frame_plot(plotFrame)
        self.frame_message(messageFrame)
        self.frame_params(self.trajectoryParamsFrame)
        self.frame_PID(self.pidParamsFrame)
        self.frame_angle2(self.targetMotorFrame)

        
        

    def frame_message(self, frame: ttk.Frame):
        messageGuiLabel= ttk.Label(frame,text="GUI Message :",font=("Helvetica",20))
        messageGuiLabel.grid(column=0, row=0, columnspan= 1, padx=5, pady=5, sticky= tk.W)
        self.messageGui = ttk.Label(frame,text="",font=("Helvetica",20))
        self.messageGui.grid(column=1, row=0, columnspan= 1, padx=5, pady=5, sticky= tk.W)
        messageDeltaLabel= ttk.Label(frame,text="Delta Message :",font=("Helvetica",20))
        messageDeltaLabel.grid(column=0, row=1, columnspan= 1, padx=5, pady=5, sticky= tk.W)
        self.messageDelta = ttk.Label(frame,text="",font=("Helvetica",20))
        self.messageDelta.grid(column=1, row=1, columnspan= 1, padx=5, pady=5, sticky= tk.W)

    def frame_mode(self, frame: ttk.Frame):
         # Frame Homming
        hommingLabel = ttk.Label(frame,text="Mode :",font=("Helvetica",20))
        hommingLabel.grid(column=0, row=0, columnspan= 3, padx=5, pady=5)

        self.stateLabel = ttk.Label(frame,text="stateRobot",font=("Helvetica",20))
        self.stateLabel.grid(column=3, row= 0, columnspan=3,padx=5,pady=5)

        textButtonMode = ["Homing", "Home", "Transparent", "Position", "Params", "Angle"] # "Points" has been removed for TP 2025
        for i, textButton in enumerate(textButtonMode):
            button = ttk.Button(frame, text=textButton, command=lambda i=i: self.robotState_button(textButtonMode[i]))
            button.grid(column=0+i, row=1, columnspan=1, padx=5, pady=5)
        
    def frame_plot(self, frame: ttk.Frame):
        # Snapshot functionality
        snapshot_label = ttk.Label(frame, text="Snapshot parent folder path")
        snapshot_label.grid(column=0, row=0, columnspan=1, padx=5, pady=5, sticky=tk.EW)
        
        path_label = ttk.Entry(frame, textvariable=self.current_snapshot_path, state="readonly", width=40)
        path_label.grid(column=1, row=0, columnspan=4, padx=5, pady=5, sticky=tk.EW)
        
        select_path_button = ttk.Button(frame, text="Select Folder", command=self.select_snapshot_folder)
        select_path_button.grid(column=0, row=1, columnspan=1, padx=5, pady=5, sticky=tk.W)
        
        snapshot_button = ttk.Button(frame, text="Snapshot!", command=self.snapshot)
        
        # Disable the button if no path is selected
        if self.current_snapshot_path.get() == "No path selected":
            snapshot_button.config(state="disabled")
        self.current_snapshot_path.trace_add("write", lambda *args: snapshot_button.config(
            state="normal" if self.current_snapshot_path.get() != "No path selected" else "disabled")
        )
        
        snapshot_button.grid(column=1, row=1, columnspan=4, padx=5, pady=5, sticky=tk.EW)
        
        textCheckbutton = ["θ₁", "θ₂", "θ₃", "x", "y", "z"]
        self.plotCheckbuttons_vars = [tk.BooleanVar() for text in textCheckbutton]


        # Create a frame to hold the checkbuttons
        checkbuttons_frame = ttk.Frame(frame)
        checkbuttons_frame.grid(column=0, row=2, columnspan=6, padx=5, pady=5, sticky=tk.EW)
        
        # Configure the columns to have equal weight
        for i in range(len(textCheckbutton)):
            checkbuttons_frame.columnconfigure(i, weight=1)
        
        # Place checkbuttons in the frame with sticky option to stretch
        for i, text in enumerate(textCheckbutton):
            checkbutton = ttk.Checkbutton(checkbuttons_frame, text=text, variable=self.plotCheckbuttons_vars[i])
            checkbutton.grid(column=i, row=0, padx=5, pady=5, sticky=tk.EW)

        self.motors_gui = motors_plot(frame, posx=0, posy=3)

    def frame_status(self,frame: ttk.Frame):
        # Frame Info Status robot
        statusRobotLabel = ttk.Label(frame,text="Status Robot",font=("Helvetica",11))
        xLabel = ttk.Label(frame,text="X",font=("Helvetica",10))
        yLabel = ttk.Label(frame,text="Y",font=("Helvetica",10))
        zLabel = ttk.Label(frame,text="Z",font=("Helvetica",10))
        theta1Label = ttk.Label(frame,text="θ₁",font=("Helvetica",10))
        theta2Label = ttk.Label(frame,text="θ₂",font=("Helvetica",10))
        theta3Label = ttk.Label(frame,text="θ₃",font=("Helvetica",10))
        self.xValue = ttk.Label(frame,text="Xvalue",font=("Helvetica",10))
        self.yValue = ttk.Label(frame,text="Yvalue",font=("Helvetica",10))
        self.zValue = ttk.Label(frame,text="Zvalue",font=("Helvetica",10))
        self.thetaValue = [ttk.Label(frame,text="θ1value",font=("Helvetica",10)),
                           ttk.Label(frame,text="θ2value",font=("Helvetica",10)),
                           ttk.Label(frame,text="θ3value",font=("Helvetica",10))]

        # Position Frame Info Status robot
        statusRobotLabel.grid(column=0, row=0, columnspan=2, padx=5,pady=5)
        xLabel.grid(column=0, row=1, columnspan=1, padx=5,pady=5)
        yLabel.grid(column=0, row=2, columnspan=1, padx=5,pady=5)
        zLabel.grid(column=0, row=3, columnspan=1, padx=5,pady=5)
        theta1Label.grid(column=0, row=4, columnspan=1, padx=5,pady=5)
        theta2Label.grid(column=0, row=5, columnspan=1, padx=5,pady=5)
        theta3Label.grid(column=0, row=6, columnspan=1, padx=5,pady=5)
        self.xValue.grid(column=1, row=1, columnspan=1, padx=5,pady=5)
        self.yValue.grid(column=1, row=2, columnspan=1, padx=5,pady=5)
        self.zValue.grid(column=1, row=3, columnspan=1, padx=5,pady=5)
        for i, n in enumerate(self.thetaValue):
            n.grid(column=1, row=(4+i), columnspan=1, padx=5,pady=5)

        imgLabel = ttk.Label(frame, image=self.simg)
        imgLabel.grid(column=0, row=7, columnspan=2)

        

    def frame_info_trajectory(self, frame: ttk.Frame):
        # Validation
        # self.sendTarget = ttk.Button(frame, text="Send Target", command=self.sendTarget_Button, state=tk.DISABLED)
        self.sendButton['target'] = ttk.Button(frame, text="Send Target", command=self.sendTarget_Button, state=tk.DISABLED)
        
        vcmd =(self.register(self.validate))
        
        # Frame Info trajectory
        infoTrajectoryLabel = ttk.Label(frame,text="Infos Trajectory",font=("Helvetica",11))
        xTargetLabel = ttk.Label(frame,text="X target",font=("Helvetica",10))
        yTargetLabel = ttk.Label(frame,text="Y target",font=("Helvetica",10))
        zTargetLabel = ttk.Label(frame,text="Z target",font=("Helvetica",10))
        self.xTargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 0, 'target'))
        self.yTargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 1, 'target'))
        self.zTargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 2, 'target'))
        

        # Position Frame Info trajectory
        infoTrajectoryLabel.grid(column=0, row=0, columnspan=2, padx=5,pady=5)
        xTargetLabel.grid(column=0, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        yTargetLabel.grid(column=0, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        zTargetLabel.grid(column=0, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.xTargetValue.grid(column=1, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.yTargetValue.grid(column=1, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.zTargetValue.grid(column=1, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        # self.sendTarget.grid(column=0, row=4, columnspan=2, padx=5, pady=5 )
        self.sendButton['target'].grid(column=0, row=4, columnspan=2, padx=5, pady=5 )

    def frame_params(self, frame: ttk.Frame):
        title = ttk.Label(frame,text="Trajectory Target",font=("Helvetica",11))
        title.grid(column=0, row=0, columnspan=2, padx=5, pady=5)
        vcmd = (self.register(self.validate))

        vmaxLabel = ttk.Label(frame,text="Vmax",font=("Helvetica",10))
        amxLabel = ttk.Label(frame,text="Amax",font=("Helvetica",10))
        dmaxLabel = ttk.Label(frame,text="Dmax",font=("Helvetica",10))
        self.vMax = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 0, 'trajectory'))
        self.aMax = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 1, 'trajectory'))
        self.dMax = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 2, 'trajectory'))
        self.sendButton['trajectory'] = ttk.Button(frame, text="Send Params", command=self.sendParmas_Button, state=tk.DISABLED)

        vmaxLabel.grid(column=0, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        amxLabel.grid(column=0, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        dmaxLabel.grid(column=0, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.vMax.grid(column=1, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.aMax.grid(column=1, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.dMax.grid(column=1, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.sendButton['trajectory'].grid(column=0, row=4, columnspan=2, padx=5,pady=5)

    def frame_PID(self, frame: ttk.Frame):
        # Validation
        vcmd =(self.register(self.validate))
        
        # Frame Info trajectory
        title = ttk.Label(frame,text="PID Value",font=("Helvetica",11))
        kpLabel = ttk.Label(frame,text="KP",font=("Helvetica",10))
        kiLabel = ttk.Label(frame,text="KI",font=("Helvetica",10))
        kdLabel = ttk.Label(frame,text="KD",font=("Helvetica",10))
        self.kpValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 0, 'PID'))
        self.kiValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 1, 'PID'))
        self.kdValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 2, 'PID'))
        self.sendButton['PID'] = ttk.Button(frame, text="Send PID", command=self.sendPID_Button, state=tk.DISABLED)
        
        # Position Frame Info trajectory
        title.grid(column=0, row=0, columnspan=2, padx=5,pady=5)
        kpLabel.grid(column=0, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        kiLabel.grid(column=0, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        kdLabel.grid(column=0, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.kpValue.grid(column=1, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.kiValue.grid(column=1, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.kdValue.grid(column=1, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.sendButton['PID'].grid(column=0, row=4, columnspan=2, padx=5, pady=5 )

    def frame_angle(self, frame: ttk.Frame):
        # Validation
        vcmd =(self.register(self.validate))
        
        # Frame Info trajectory
        title = ttk.Label(frame,text="Angle Target",font=("Helvetica",11))
        theta1Label = ttk.Label(frame,text="θ₁",font=("Helvetica",10))
        theta2Label = ttk.Label(frame,text="θ₂",font=("Helvetica",10))
        theta3Label = ttk.Label(frame,text="θ₃",font=("Helvetica",10))
        self.theta1TargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 0, 'angle'))
        self.theta2TargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 1, 'angle'))
        self.theta3TargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 2, 'angle'))
        self.sendButton['angle'] = ttk.Button(frame, text="Send Angle", command=self.sendAngle_Button, state=tk.DISABLED)
        
        # Position Frame Info trajectory
        title.grid(column=0, row=0, columnspan=2, padx=5,pady=5)
        theta1Label.grid(column=0, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        theta2Label.grid(column=0, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        theta3Label.grid(column=0, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.theta1TargetValue.grid(column=1, row=1, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.theta2TargetValue.grid(column=1, row=2, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.theta3TargetValue.grid(column=1, row=3, columnspan=1, padx=5,pady=5,sticky= tk.W)
        self.sendButton['angle'].grid(column=0, row=4, columnspan=2, padx=5, pady=5 )

    def frame_angle2(self, frame: ttk.Frame):
        # Validation
        vcmd =(self.register(self.validate))
        
        # Frame Info trajectory
        title = ttk.Label(frame,text="Angle Target",font=("Helvetica",11))
        for i in range(3):
            thetaRadioButton = ttk.Radiobutton(frame,text=(f'Motor {i+1}'), variable=self.choiceAngle, value=i)
            thetaRadioButton.grid(column=0+i, row=1, padx=5, pady=5,sticky= tk.W)
        label = ttk.Label(frame,text="Trajectory")
        label.grid(column=0, row=2, padx=5, pady=5)
        trajectoryChoiceText = ["No", "Parabolic"]
        for i, text in enumerate(trajectoryChoiceText):
            radioButton = ttk.Radiobutton(frame, text=text, variable=self.trajectoryChoice, value=i)
            radioButton.grid(column=1+i, row=2, padx=5, pady=5,sticky= tk.W)


        targetAngleLabel = ttk.Label(frame,text="Target angle",font=("Helvetica",10))
        self.targetAngleEntry = ttk.Entry(frame, validate="all", validatecommand=(vcmd,'%P', 0, 'angle2'))
        # self.theta3TargetValue = ttk.Entry(frame, validate="focus", validatecommand=(vcmd,'%P', 2, 'angle'))
        self.sendButton['angle2'] = ttk.Button(frame, text="Send Angle", command=self.sendAngle_Button2, state=tk.DISABLED)
        
        # Position Frame Info trajectory
        title.grid(column=0, row=0, columnspan=3, padx=5,pady=5)
        targetAngleLabel.grid(column=0, row=3, columnspan=1, padx=5,pady=5)
        self.targetAngleEntry.grid(column=1, row=3, columnspan=2, padx=5,pady=5)
        self.sendButton['angle2'].grid(column=0, row=4, columnspan=2, padx=5, pady=5)
    
    def select_snapshot_folder(self):
        folder_path = tk.filedialog.askdirectory()
        if folder_path:
            self.current_snapshot_path.set(folder_path)
        else:
            self.current_snapshot_path.set("No path selected")
            tk.messagebox.showerror("Error", "No folder selected for snapshots")
    
    def snapshot(self):
        folder_path = self.current_snapshot_path.get()
        if folder_path == "No path selected":
            tk.messagebox.showerror("Error", "No folder selected for snapshots")
            return
        
        self.want_snapshot = True

    def is_float(self, string: str):
        try:
            float(string)
            return True
        except ValueError:
            return False

    def validate(self, value: str, index: str, button: str):
        index = int(index)
        if self.is_float(value):
            if (float(value)>=self.minValue[button][index]) & (float(value)<=float(self.maxValue[button][index])):
                self.good[button][index] = True
                if self.good[button][0] & self.good[button][1] & self.good[button][2]:
                    self.sendButton[button].configure(state=tk.NORMAL)
                return True
            else:
                self.good[button][index] = False
                self.sendButton[button].configure(state=tk.DISABLED)
                return False
        else:
            self.good[button][index] = False
            self.sendButton[button].configure(state=tk.DISABLED)
            return False
        
    def plotChoice_radioButton(self):
        self.motors_gui.plotChoice = int(self.plotChoice.get())

    def robotState_radioButton(self):
        self.robotState = str(self.robotStateTK.get())
        self.stateLabel.configure(text=self.robotState)
        if (self.robotState != "dead") & (self.robotState != "homing"):
            self.hommingRadiobutton.config(state= tk.DISABLED)

    def robotState_button(self, value: str):
        self.robotState = value

    def sendTarget_Button(self):
        if self.good['target'][0] & self.good['target'][1] & self.good['target'][2]:
            self.xTarget = float(self.xTargetValue.get())
            self.yTarget = float(self.yTargetValue.get())
            self.zTarget = float(self.zTargetValue.get())
            self.messageGui.config(text=f'Target update -> X : {self.xTarget}, Y : {self.yTarget}, Z : {self.zTarget}')
            self.newTarget = True

    def sendPID_Button(self):
        self.PID['kp'] = float(self.kpValue.get())
        self.PID['ki'] = float(self.kiValue.get())
        self.PID['kd'] = float(self.kdValue.get())
        self.messageGui.config(text=f"PID update -> Kp : {self.PID['kp']}, Ki : {self.PID['ki']}, Kd : {self.PID['kd']}")
        self.newParams = True

    def sendAngle_Button(self):
        self.thetaTarget[0] = float(self.kpValue.get())
        self.thetaTarget[1] = float(self.kiValue.get())
        self.thetaTarget[2] = float(self.kdValue.get())
        self.messageGui.config(text=f'Target angle update -> θ₁ : {self.thetaTarget[0]}, θ₂ : {self.thetaTarget[1]}, θ₃ : {self.thetaTarget[2]}')

    def sendAngle_Button2(self):
        self.targetAngle = float(self.targetAngleEntry.get())
        self.messageGui.config(text=f'Motor {self.choiceAngle.get()+1}, Angle : {self.targetAngle}')
        self.newTargetAngle = True

    def sendParmas_Button(self):
        self.max_speed = float(self.vMax.get())
        self.max_acc = float(self.aMax.get())
        self.max_dec = float(self.dMax.get())
        self.messageGui.config(text=f'Parameters update -> Speed : {self.max_speed}, Acc : {self.max_acc}, Dcc : {self.max_dec}')

    def start_gui(self):
        if self.plot:
            ani = FuncAnimation(self.motors_gui.fig, self.motors_gui.animate, fargs=(self.plotCheckbuttons_vars,), interval=200, blit= True, cache_frame_data=False) 
        
        sv_ttk.set_theme("light")
        self.mainloop()

if __name__ == '__main__':
    gui_main = gui()
    gui_main.start_gui()