#include <math.h>
#include <stdint.h>
#include "lutmath.h"

/// The sine lookup table. Also used for cosine.
static const float sin_LUT[805] = {
  0.000000, 0.007815, 0.015629, 0.023443, 0.031255, 0.039065, 0.046872, 0.054677, 0.062479, 0.070276,
  0.078070, 0.085858, 0.093641, 0.101419, 0.109191, 0.116955, 0.124713, 0.132463, 0.140205, 0.147938,
  0.155663, 0.163377, 0.171082, 0.178777, 0.186460, 0.194132, 0.201792, 0.209440, 0.217075, 0.224697,
  0.232305, 0.239899, 0.247479, 0.255043, 0.262591, 0.270124, 0.277640, 0.285139, 0.292621, 0.300085,
  0.307530, 0.314957, 0.322364, 0.329752, 0.337120, 0.344467, 0.351793, 0.359097, 0.366380, 0.373640,
  0.380878, 0.388092, 0.395282, 0.402449, 0.409590, 0.416707, 0.423798, 0.430864, 0.437903, 0.444915,
  0.451900, 0.458858, 0.465787, 0.472688, 0.479561, 0.486404, 0.493217, 0.500000, 0.506753, 0.513474,
  0.520164, 0.526823, 0.533449, 0.540043, 0.546604, 0.553131, 0.559625, 0.566084, 0.572509, 0.578899,
  0.585253, 0.591572, 0.597855, 0.604101, 0.610310, 0.616482, 0.622617, 0.628713, 0.634771, 0.640790,
  0.646770, 0.652710, 0.658611, 0.664471, 0.670291, 0.676070, 0.681808, 0.687504, 0.693158, 0.698769,
  0.704338, 0.709864, 0.715347, 0.720786, 0.726181, 0.731531, 0.736837, 0.742098, 0.747314, 0.752484,
  0.757608, 0.762685, 0.767716, 0.772700, 0.777638, 0.782527, 0.787369, 0.792162, 0.796908, 0.801604,
  0.806252, 0.810850, 0.815399, 0.819898, 0.824347, 0.828746, 0.833094, 0.837391, 0.841637, 0.845832,
  0.849975, 0.854066, 0.858105, 0.862092, 0.866025, 0.869906, 0.873734, 0.877509, 0.881230, 0.884897,
  0.888510, 0.892068, 0.895573, 0.899022, 0.902417, 0.905757, 0.909041, 0.912270, 0.915443, 0.918560,
  0.921621, 0.924625, 0.927574, 0.930465, 0.933300, 0.936078, 0.938798, 0.941462, 0.944068, 0.946616,
  0.949106, 0.951538, 0.953913, 0.956229, 0.958486, 0.960685, 0.962826, 0.964907, 0.966930, 0.968893,
  0.970798, 0.972643, 0.974429, 0.976155, 0.977821, 0.979428, 0.980975, 0.982463, 0.983890, 0.985257,
  0.986564, 0.987810, 0.988997, 0.990122, 0.991188, 0.992193, 0.993137, 0.994021, 0.994844, 0.995606,
  0.996307, 0.996948, 0.997528, 0.998046, 0.998504, 0.998901, 0.999237, 0.999511, 0.999725, 0.999878,
  0.999969, 1.000000, 0.999969, 0.999878, 0.999725, 0.999511, 0.999237, 0.998901, 0.998504, 0.998046,
  0.997528, 0.996948, 0.996307, 0.995606, 0.994844, 0.994021, 0.993137, 0.992193, 0.991188, 0.990122,
  0.988997, 0.987810, 0.986564, 0.985257, 0.983890, 0.982463, 0.980975, 0.979428, 0.977821, 0.976155,
  0.974429, 0.972643, 0.970798, 0.968893, 0.966930, 0.964907, 0.962826, 0.960685, 0.958486, 0.956229,
  0.953913, 0.951538, 0.949106, 0.946616, 0.944068, 0.941462, 0.938798, 0.936078, 0.933300, 0.930465,
  0.927574, 0.924625, 0.921621, 0.918560, 0.915443, 0.912270, 0.909041, 0.905757, 0.902417, 0.899022,
  0.895573, 0.892068, 0.888510, 0.884897, 0.881230, 0.877509, 0.873734, 0.869906, 0.866025, 0.862092,
  0.858105, 0.854066, 0.849975, 0.845832, 0.841637, 0.837391, 0.833094, 0.828746, 0.824347, 0.819898,
  0.815399, 0.810850, 0.806252, 0.801604, 0.796908, 0.792162, 0.787369, 0.782527, 0.777638, 0.772700,
  0.767716, 0.762685, 0.757608, 0.752484, 0.747314, 0.742098, 0.736837, 0.731531, 0.726181, 0.720786,
  0.715347, 0.709864, 0.704338, 0.698769, 0.693158, 0.687504, 0.681808, 0.676070, 0.670291, 0.664471,
  0.658611, 0.652710, 0.646770, 0.640790, 0.634771, 0.628713, 0.622617, 0.616482, 0.610310, 0.604101,
  0.597855, 0.591572, 0.585253, 0.578899, 0.572509, 0.566084, 0.559625, 0.553131, 0.546604, 0.540043,
  0.533449, 0.526823, 0.520164, 0.513474, 0.506753, 0.500000, 0.493217, 0.486404, 0.479561, 0.472688,
  0.465787, 0.458858, 0.451900, 0.444915, 0.437903, 0.430864, 0.423798, 0.416707, 0.409590, 0.402449,
  0.395282, 0.388092, 0.380878, 0.373640, 0.366380, 0.359097, 0.351793, 0.344467, 0.337120, 0.329752,
  0.322364, 0.314957, 0.307530, 0.300085, 0.292621, 0.285139, 0.277640, 0.270124, 0.262591, 0.255043,
  0.247479, 0.239899, 0.232305, 0.224697, 0.217075, 0.209440, 0.201792, 0.194132, 0.186460, 0.178777,
  0.171082, 0.163377, 0.155663, 0.147938, 0.140205, 0.132463, 0.124713, 0.116955, 0.109191, 0.101419,
  0.093641, 0.085858, 0.078070, 0.070276, 0.062479, 0.054677, 0.046872, 0.039065, 0.031255, 0.023443,
  0.015629, 0.007815, 0.000000, -0.007815, -0.015629, -0.023443, -0.031255, -0.039065, -0.046872, -0.054677,
  -0.062479, -0.070276, -0.078070, -0.085858, -0.093641, -0.101419, -0.109191, -0.116955, -0.124713, -0.132463,
  -0.140205, -0.147938, -0.155663, -0.163377, -0.171082, -0.178777, -0.186460, -0.194132, -0.201792, -0.209440,
  -0.217075, -0.224697, -0.232305, -0.239899, -0.247479, -0.255043, -0.262591, -0.270124, -0.277640, -0.285139,
  -0.292621, -0.300085, -0.307530, -0.314957, -0.322364, -0.329752, -0.337120, -0.344467, -0.351793, -0.359097,
  -0.366380, -0.373640, -0.380878, -0.388092, -0.395282, -0.402449, -0.409590, -0.416707, -0.423798, -0.430864,
  -0.437903, -0.444915, -0.451900, -0.458858, -0.465787, -0.472688, -0.479561, -0.486404, -0.493217, -0.500000,
  -0.506753, -0.513474, -0.520164, -0.526823, -0.533449, -0.540043, -0.546604, -0.553131, -0.559625, -0.566084,
  -0.572509, -0.578899, -0.585253, -0.591572, -0.597855, -0.604101, -0.610310, -0.616482, -0.622617, -0.628713,
  -0.634771, -0.640790, -0.646770, -0.652710, -0.658611, -0.664471, -0.670291, -0.676070, -0.681808, -0.687504,
  -0.693158, -0.698769, -0.704338, -0.709864, -0.715347, -0.720786, -0.726181, -0.731531, -0.736837, -0.742098,
  -0.747314, -0.752484, -0.757608, -0.762685, -0.767716, -0.772700, -0.777638, -0.782527, -0.787369, -0.792162,
  -0.796908, -0.801604, -0.806252, -0.810850, -0.815399, -0.819898, -0.824347, -0.828746, -0.833094, -0.837391,
  -0.841637, -0.845832, -0.849975, -0.854066, -0.858105, -0.862092, -0.866025, -0.869906, -0.873734, -0.877509,
  -0.881230, -0.884897, -0.888510, -0.892068, -0.895573, -0.899022, -0.902417, -0.905757, -0.909041, -0.912270,
  -0.915443, -0.918560, -0.921621, -0.924625, -0.927574, -0.930465, -0.933300, -0.936078, -0.938798, -0.941462,
  -0.944068, -0.946616, -0.949106, -0.951538, -0.953913, -0.956229, -0.958486, -0.960685, -0.962826, -0.964907,
  -0.966930, -0.968893, -0.970798, -0.972643, -0.974429, -0.976155, -0.977821, -0.979428, -0.980975, -0.982463,
  -0.983890, -0.985257, -0.986564, -0.987810, -0.988997, -0.990122, -0.991188, -0.992193, -0.993137, -0.994021,
  -0.994844, -0.995606, -0.996307, -0.996948, -0.997528, -0.998046, -0.998504, -0.998901, -0.999237, -0.999511,
  -0.999725, -0.999878, -0.999969, -1.000000, -0.999969, -0.999878, -0.999725, -0.999511, -0.999237, -0.998901,
  -0.998504, -0.998046, -0.997528, -0.996948, -0.996307, -0.995606, -0.994844, -0.994021, -0.993137, -0.992193,
  -0.991188, -0.990122, -0.988997, -0.987810, -0.986564, -0.985257, -0.983890, -0.982463, -0.980975, -0.979428,
  -0.977821, -0.976155, -0.974429, -0.972643, -0.970798, -0.968893, -0.966930, -0.964907, -0.962826, -0.960685,
  -0.958486, -0.956229, -0.953913, -0.951538, -0.949106, -0.946616, -0.944068, -0.941462, -0.938798, -0.936078,
  -0.933300, -0.930465, -0.927574, -0.924625, -0.921621, -0.918560, -0.915443, -0.912270, -0.909041, -0.905757,
  -0.902417, -0.899022, -0.895573, -0.892068, -0.888510, -0.884897, -0.881230, -0.877509, -0.873734, -0.869906,
  -0.866025, -0.862092, -0.858105, -0.854066, -0.849975, -0.845832, -0.841637, -0.837391, -0.833094, -0.828746,
  -0.824347, -0.819898, -0.815399, -0.810850, -0.806252, -0.801604, -0.796908, -0.792162, -0.787369, -0.782527,
  -0.777638, -0.772700, -0.767716, -0.762685, -0.757608, -0.752484, -0.747314, -0.742098, -0.736837, -0.731531,
  -0.726181, -0.720786, -0.715347, -0.709864, -0.704338, -0.698769, -0.693158, -0.687504, -0.681808, -0.676070,
  -0.670291, -0.664471, -0.658611, -0.652710, -0.646770, -0.640790, -0.634771, -0.628713, -0.622617, -0.616482,
  -0.610310, -0.604101, -0.597855, -0.591572, -0.585253, -0.578899, -0.572509, -0.566084, -0.559625, -0.553131,
  -0.546604, -0.540043, -0.533449, -0.526823, -0.520164, -0.513474, -0.506753, -0.500000, -0.493217, -0.486404,
  -0.479561, -0.472688, -0.465787, -0.458858, -0.451900, -0.444915, -0.437903, -0.430864, -0.423798, -0.416707,
  -0.409590, -0.402449, -0.395282, -0.388092, -0.380878, -0.373640, -0.366380, -0.359097, -0.351793, -0.344467,
  -0.337120, -0.329752, -0.322364, -0.314957, -0.307530, -0.300085, -0.292621, -0.285139, -0.277640, -0.270124,
  -0.262591, -0.255043, -0.247479, -0.239899, -0.232305, -0.224697, -0.217075, -0.209440, -0.201792, -0.194132,
  -0.186460, -0.178777, -0.171082, -0.163377, -0.155663, -0.147938, -0.140205, -0.132463, -0.124713, -0.116955,
  -0.109191, -0.101419, -0.093641, -0.085858, -0.078070, -0.070276, -0.062479, -0.054677, -0.046872, -0.039065,
  -0.031255, -0.023443, -0.015629, -0.007815, -0.000000
};


/// Internal sine LUT function, only works for positive arguments < M_TWOPI
static float internal_sinlut(const float in) __attribute__((const));

float internal_sinlut(const float in)
{
  uint16_t index;
  index = in / M_TWOPI * 805;
  return sin_LUT[index];
}

float sinlut(float in)
{
  uint8_t neg;
  float v;

  // Keeps and removes the sign of the input
  if (in < 0) {
    neg = 1;
    in = -in;
  } else neg = 0;

  // sin(M_TWOPI * k + x) = sin(x) --> finds x for k = 0
  while (in >= M_TWOPI)
    in -= M_TWOPI;

  v = internal_sinlut (in);
  if (neg) return -v;
    else return v;
}

float coslut(float in)
{
  return sinlut(in + M_PI_2);
}
