% This script displays speed and current
% v02 - A. Hodder
% v03 - ylim to not have negative values
% v04 - ylim1 et ylim2 outside if

%% Load data from SimOut
fig_Time = SimOut.Time;
fig_Speed = SimOut.Data(:,2);   % Speed = 2ème entrée de SimOut
fig_Courant = SimOut.Data(:,3); % Courant = 3ème entrée de SimOut 

% Creates figure with a correct size to be included in the MatlabApp
fig_offset = 0;
fig_width = 1000;
fig_height = 800;

% récupère le handle s'il existe déjà pour afficher 2 figures
if not(exist('fig_handle','var'))
  fig_handle = figure('position',[fig_offset,fig_offset,fig_width,fig_height], 'Name','Simulation Démarrage Moteur DC','NumberTitle','off');  
else
  if not(ishandle(fig_handle))   
    fig_handle = figure('position',[fig_offset,fig_offset,fig_width,fig_height], 'Name','Simulation Démarrage Moteur DC','NumberTitle','off');    
  end
end

ylim1 = 1.1*max(fig_Speed);
ylim2 = 1.1*max(fig_Courant);

yyaxis right
plot(fig_Time,fig_Speed);
ylim([0 ylim1])
ylabel('Vitesse [tr/min]');
hold on
yyaxis left
plot(fig_Time,fig_Courant);
ylim([0 ylim2])
grid on
title('Démarrage du moteur DC');
xlabel('Temps [s]');
ylabel('Courant [A]');

saveas(fig_handle,'StartupImage1.png');