reset;
################################
# DTmin optimisation
################################
# Sets & Parameters

set Time default {}; #your time set from the MILP part
param Qheating{Time}; #your heat demand from the MILP part, will become a variable in the case of heat recovery from air ventilation
param top{Time}; #your operating time from the MILP part

param EPFLMediumT 	:= 65; #[degC] - desired temperature high temperature loop
param EPFLMediumOut := 30; # temperature of return low temperature loop

param CarnotEff 	:= 0.55; #assumption: carnot efficiency of heating heat pumps
param Cel 			:= 0.20; #[CHF/kWh] operating cost for buying electricity from the grid

param THPhighin 	:= 7; #[deg C] temperature of water coming from lake into the evaporator of the HP
param THPhighout 	:= 3; #[deg C] temperature of water coming from lake into the evaporator of the HP

################################
# Variables

var E{Time} 		>= 0.001; # kW] electricity consumed by the heat pump (using pre-heated lake water)
var TLMCond{Time} 	>= 0.001; #[K] logarithmic mean temperature in the condensor of the heating HP (using pre-heated lake water)
var Qevap{Time} 	>= 0.001; #[kW] heat extracted in the evaporator of the heating HP (using pre-heated lake water)
var Qcond{Time} 	>= 0.001; #[kW] heat delivered in the condensor of the heating HP (using pre-heated lake water)
var COP{Time} 		>= 0.001; #coefficient of performance of the heating HP (using pre-heated lake water)

var OPEX 			>= 0.001; #[CHF/year] operating cost

var TLMEvapHP{Time} >= 0.001; #[K] logarithmic mean temperature in the evaporator of the heating HP

var Flow{Time} 		>= 0.001; #lake water entering free coling HEX
var MassEPFL{Time} 	>= 0.001; # MCp of EPFL heating system [KJ/(s degC)]

################################
# Constraints
################################

subject to Flows{t in Time}:
	MassEPFL[t] = (Qheating[t]/top[t])/(EPFLMediumT-EPFLMediumOut);	

## MEETING HEATING DEMAND, ELECTRICAL CONSUMPTION

subject to QEvaporator{t in Time}: #water side of evaporator that takes flow from Free cooling HEX
	Qevap[t] = Flow[t]*4.18*(THPhighin - THPhighout);

subject to QCondensator{t in Time}: #water side of evaporator that takes flow from Free cooling HEX
	Qcond[t] = MassEPFL[t]*(EPFLMediumT - EPFLMediumOut);	

subject to Electricity1{t in Time}: #the electricity consumed in the HP (using pre-heated lake water) can be computed using the heat delivered and the heat extracted
	E[t] = Qcond[t] - Qevap[t];

subject to Electricity{t in Time}: #the electricity consumed in the HP (using pre-heated lake water) can be computed using the heat delivered and the COP
	E[t]*COP[t] = Qcond[t];

subject to COPerformance{t in Time}: #the COP can be computed using the carnot efficiency and the logarithmic mean temperatures in the condensor and in the evaporator
	COP[t] = CarnotEff* TLMCond[t]/(TLMCond[t] - TLMEvapHP[t]);

subject to dTLMCondensor{t in Time}: #the logarithmic mean temperature is known (=TEPFLMedium), Note: should be in K
	TLMCond[t] =(EPFLMediumOut-EPFLMediumT)/log((EPFLMediumOut+273)/(EPFLMediumT+273));

subject to dTLMEvaporatorHPhigh{t in Time}: #the logarithmic mean temperature can be computed using the inlet and outlet temperatures, Note: should be in K
	TLMEvapHP[t] = (THPhighin - THPhighout)/log((THPhighin+273.15)/(THPhighout+273.15));

subject to QEPFLausanne{t in Time}: #the heat demand of EPFL should be the sum of the heat delivered by the 2 systems;
	Qheating[t]/top[t] = Qcond[t];

subject to OPEXcost: #the operating cost can be computed using the electricity consumed in the two heat pumps
	OPEX = sum{t in Time}(Cel*E[t]*top[t]);

################################
minimize obj : OPEX;