reset;

#########################################################################################
# HOW TO RUN YOUR AMPL CODE:
# from Windows commandline type: ampl juice17.mod |Tee output.txt
# from ampl command line type: model juice17.mod 
#########################################################################################


#########################################################################################
## PARAMETERS
#########################################################################################
# Heat capacities
param cp_juice 			:= 3.8;								# heat capacity of juice	kJ/kgK
param cp_water 			:= 4.18;							# heat capacity of water kJ/kgK
param cp_empty_bottles 	:= 0.75; 							# heat capacity 0.75 for glass, 1.67 for PET
param cp_bottles 		:= 2.6; 							# heat capacity 2.6 for glass, 3.7 for PET  (filled bottles)

# Flow rates
param m1				:= 8;								# liter/second of juice
param m_empty_bottles 	:= 0.37; 							# mass of bottle 0.370 for glass, 0.04 for PET ( empty bottles )
param bps				:= m1/0.5; 							# bottles per second
param m_bottles			:= bps*m_empty_bottles + m1;		# mass of filled bottles

# Temperatures
param T1 				:= 1;								# inlet temperature of juice oC
param Ttarget 			:= 90;								# target temperature of juice (pasteurisation)
param Tempty_bottles	:= 40; 								# temperature of empty bottles before bottling: 40 for glass, 40 for PET
param Twater			:= 15;								# Inlet water
param Trefrigeration	:= 10;
param DTmin				:= 2;
param Tsteam			:= 120; 							# Temperature of 2bar steam 

# COSTING
# Resources
param NGprice			:= 0.06; # CHF/kWh
param watercost			:= 0.01; # CHF/m3
param Elprice			:= 0.15; # CHF/kWh_el
param optime 			:= 3000;
param eta_boiler		:= 0.85;
param COP				:= 3;
param Uref				:= 0.5; # kW/m2K
param i					:= 0.08;
param n					:= 20;
param MS2000			:= 400;
param MS2017			:= 562;
param Cref_ex			:= 700;
param beta_ex			:= 0.7;
param Cref_hp			:= 3400;
param beta_hp			:= 0.85;
param BM_ex				:= 4.74;
param BM_boiler			:= 2;
param BM_hp				:= 2;



#########################################################################################
## VARIABLES
#########################################################################################

var ex1 >= 1;			# example variable
var ex2	>= 3 <= 50;		# example variable


#########################################################################################
## CONSTRAINTS
#########################################################################################


##############################################
# Example constraint

subject to example1:
ex1 = NGprice*ex2 + 3;


/*
BELOW THIS LONG COMMENT YOU SHOULD TYPE YOUR CONSTRAINTS
*/





	
#########################################################################################
## COSTING OBJECTIVE FUNCTION
#########################################################################################



minimize Obj: ex1;


solve;

#########################################################################################
## DISPLAY COMMANDS
#########################################################################################
printf '\n\n';
printf '------------------------------------------------------\n';
printf 'RESULTS\n';
printf '------------------------------------------------------\n';
printf 'Objective function value          :\t %0.4f $\n', ex1;
printf '------------------------------------------------------\n';
printf 'Test succeeded\n';
printf '------------------------------------------------------\n';

end;