clear all;
clc;

% Unstable system
A=-0.2*[1 -1 2;3 -3.2 -3.5;5 -6 7];
B=eye(3);
n = size(A,1);
m = size(B,2);
Sigma_0 = eye(n);


disp('We consider the S-LQR problem with A, B, Sigma_0 given by')
A
B
Sigma_0
disp('and cost matrices Q and R given by')
%Weight matrices for the cost
Q = eye(n)
R = eye(m)

%Information structure
disp('We require that the controller complies with an information structure')
S=[1 0 0;1 0 1;0 1 0]

disp('Unfortunately, the LQR Controller')
P = idare(A,B,Q,R,zeros(n,m),eye(n));
K_LQR = inv(B'*P*B+R)*B'*P*A
disp('is CENTRALIZED and therefore not implementable. The LQR cost:')
cost_LQR = trace(P * Sigma_0)
disp('serves as a lower bound to the minimum achievable cost of a distributed controller')

%% The file search_random_K0 finds an initial stabilizing controller in Sparse(S) by brute force
% search_random_K0   


%% BEGIN
fprintf('\n\n')
disp('We start with a distributed controller K0 ')

K0 = [-1.1189 0 0;-0.6894 0 -1.9114; 0 1.7018 0];   
%K_converged_bad = [-0.7598 0 0;-0.8954 0 -0.2618;0 2.7020 0]; %63.077438
K0_iControl = [-0.0900 0 0; -1.2633 0 3.3683;0 0.7425 0]; 


K = K0_iControl;                     %% Here, initialize with either K0 or K0_iControl
                            %%% K = K0 converges to a cost of 63.077438 
                            %%% K = K0_iControl converges to a casto of 43.0588
                            
disp('That is stabilizing and has a cost')
cost_K0 = trace(dlyap((A-B*K)',Q+K'*R*K)*Sigma_0)

eta=0.000005; %step-size

stopping=10000; %stopping 
count=0;


fprintf('***********+\n***********\n Start GD\n ***********\n********\n')
%fprintf('Initial Cost: %f\n\n\n', cost_K0)

Sigma=zeros(n,n);

                            
while(stopping>0.000001)
    count = count+1;
    P = dlyap((A-B*K)',Q+K'*R*K);

    Sigma = dlyap(A-B*K,Sigma_0);
    DeltaJ = 2*((R+B'*P*B)*K-B'*P*A)*Sigma;
    
    DeltaJ_projected = DeltaJ .* S;
    
    stopping = sum(sum(DeltaJ_projected .* DeltaJ_projected));
    if(mod(count,10000)==0)
        cost_K = trace(P*Sigma_0);
        fprintf('Iteration: %d, Cost: %f\n\n\n', count, cost_K)
    end
    K = K-eta * DeltaJ_projected; 
    
    K = K .* S;
    
end


disp('The controller found with PGD is')
K
disp('And yields a cost')
cost_K
disp('While the best S-LQR controller (which is centralized) has a cost of')
cost_LQR