clear all;
clc;

%% SYSTEM DEFINITION
A = -0.1*[1 -1 2;3 -3.2 -3.5;5 -6 7];
B = eye(3);
n = size(A,1);
m = size(B,2);
Sigma_0 = eye(n);

disp('We consider the S-LQR problem with A, B, Sigma_0 given by')
A
B
Sigma_0
disp('and cost matrices Q and R given by')
%Weight matrices for the cost
Q = eye(n)
R = eye(m)

fprintf('\n\n')
disp('We start with a  controller K0 ')
K0 = zeros(3,3)
disp('That is stabilizing and has a cost')
cost_K0 = trace(dlyap((A-B*K0)',Q+K0'*R*K0)*Sigma_0)


eta = 0.0005; %step-size
norm_gradient = 9999; %stopping criterion
count=0;
fprintf('***********+\n***********\n Start GD\n ***********\n********\n')

Sigma = zeros(n,n);
K = K0;
while(norm_gradient>0.000001)
    count = count+1;
    P = dlyap((A-B*K)',Q+K'*R*K);
    Sigma = dlyap(A-B*K,Sigma_0);
    DeltaJ = 2*((R+B'*P*B)*K-B'*P*A)*Sigma;
    norm_gradient = norm(DeltaJ);
    if(mod(count,100)==0)
        cost_K = trace(P*Sigma_0);
        fprintf('Iteration: %d, Cost: %f\n\n\n', count, cost_K)
    end
    K = K-eta * DeltaJ; 
end

%% LQR Controller comparison
P = idare(A,B,Q,R,zeros(n,m),eye(n));
K_LQR = inv(B'*P*B+R)*B'*P*A
cost_LQR = trace(P * Sigma_0)
disp('The controller found with gradient descent is')
K
disp('The LQR controller is')
K_LQR



