clear all;
clc;

%% SYSTEM DEFINITION
A = -0.1*[1 -1 2;3 -3.2 -3.5;5 -6 7];
B = eye(3);
n = size(A,1);
m = size(B,2);
Sigma_0 = eye(n);

disp('We consider the S-LQR problem with A, B, Sigma_0 given by')
A
B
Sigma_0
disp('and cost matrices Q and R given by')
%Weight matrices for the cost
Q = eye(n)
R = eye(m)


%% START EXERCISE

fprintf('\n\n')
disp('We start with a controller K0 ')
% Define a controller K0 that is stabilizing by design

disp('That is stabilizing and has a cost')
% Compute the cost of the initial controller K0



fprintf('**********************\n       Start GD\n *******************\n')
%% Implement the Gradient Descent Algorithm

%% PSEUDOCODE

%INITIALIZATION

% K = K0;
% eta = ?    it has to be small-enough
% while(norm_gradient > epsilon)
    % Compute P_K
    % Compute Sigma_K
    % Compute DeltaJ, that is, the gradient of J(K) with respect to K
    % K = K - eta * DeltaJ
% end



%% LQR Controller comparison
P = idare(A,B,Q,R,zeros(n,m),eye(n));
K_LQR = inv(B'*P*B+R)*B'*P*A;
cost_LQR = trace(P * Sigma_0);

disp('The controller found with gradient descent is')
% Insert here

disp('The LQR controller is')
K_LQR



