clear all;
clc;

% Unstable system
A = 2*[0.5 -1;3 -3];
B = [0;1];
n = size(A,1);
m = size(B,2);
Sigma_0 = eye(n);

disp('We consider the S-LQR problem with A, B, Sigma_0 given by')
A
B
Sigma_0
disp('and cost matrices Q and R given by')
%Weight matrices for the cost
Q = eye(n)
R = eye(m)



%search_random_K0
%Ksol=K;
disp('The controller K0 is')
K0 = place(A,B,[0;0.5])
disp('K0 has a cost of')
P_K0 = dlyap((A-B*K0)',Q+K0'*R*K0);
cost_K0 = trace(P_K0*Sigma_0)


disp('The minimum cost achieved by the S-LQR controller is')
P = idare(A,B,Q,R,zeros(n,m),eye(n));
K_LQR = inv(B'*P*B+R)*B'*P*A;
cost_LQR = trace(P * Sigma_0)


fprintf('The Performance Improvement is %f percent\n',100*(1-cost_LQR/cost_K0))



