clear
close all

%% Define system

tau1 = 250;
tau2 = 25;
a = 0.3;

sys = tf(a,[tau2 (1+tau2/tau1) 1/tau1]);

step(sys)

%% Define system to fit

K = 70;
T = 300;
tau = 1;

P = tf(K,[T 1],'inputdelay',tau);

step(sys,P)


%% Choose K as the dcgain
K = dcgain(sys);

P = tf(K,[T 1],'inputdelay',tau);
step(sys,P)

% Fiddle with tau and T

tau = 15;
T = 260;
P = tf(K,[T 1],'inputdelay',tau);
step(sys,P)

%% Compute the 'good values for the gains'

Kp = (0.15*tau + 0.35*T) / (K*tau);
Ki = (0.46*tau + 0.02*T) / (K*tau^2);

s = tf([1 0],1);
C = Kp + Ki/s;

%% Plot the step response of the controller - unbounded

step(C)

%% Show the closed-loop response - compare to slide 61 - zeigler-nichols

step(feedback(C*sys,1))