function pzLocations(dat)

if nargin < 1, dat = []; end
figure(2); clf; hold on
figure(1); clf; hold on;
hl = []; hx = [];
plotPoleConstraints(dat);

if ~isfield(dat, 'xx'), dat.xx = 10; end;
xx = dat.xx;

while 1
  figure(1)
  [sig,wd,button] = ginput(1);

  switch button
    case 27 % esc
      return
    case 1
    otherwise
      figure(2); clf; hold on
      figure(1); clf; hold on;
      hl = []; hx = [];
      plotPoleConstraints(dat);
      continue
  end
  
  figure(1)
  if ~isempty(hl)
    set(hl,'color',0.5*[1 1 1],'linewidth',1);
  end
  if ~isempty(hx)
    set(hx,'color',0.5*[1 1 1],'linewidth',1);
  end
  
  hx = plot(sig*[1;1],wd*[1,-1],'o','markersize',16,'linewidth',2);
  axis([-xx xx -xx xx])
  
  ticks = [-xx:2:xx];
  set(gca, 'xtick',ticks,'ytick',ticks);
  
  
  wn = sqrt(sig^2+wd^2);
  zeta = -sig/wn;

  str = sprintf('wn = %.2f zeta = %.2f\n', wn, zeta);
  title(str)
  
  sys = tf(wn^2,[1 2*zeta*wn wn^2]);
  figure(2); hold on
  [y,t] = step(sys,5);
  hl = plot(t,y,'b','linewidth',2);
  set(gca,'fontsize',16)
  grid on
end

