function plotPoleConstraints(dat)

%Mp,Ts,Tp,xx,nn)

if nargin < 1, dat = []; end
if ~isfield(dat, 'nn'), dat.nn = 2; end
if ~isfield(dat, 'xx'), dat.xx = 10; end

nn = dat.nn;
xx = dat.xx;

if nargin < 1
  dat.Mp = .2;
  dat.Ts = 4;
  dat.Tp = 1;
end

axis([-xx xx -xx xx])
ticks = [-xx:nn:xx];
set(gca, 'xtick',ticks,'ytick',ticks);
plot([0;0],[-xx;xx],'k','linewidth',2); hold on
plot([-xx;xx],[0;0],'k','linewidth',2); hold on
grid on
set(gca,'fontsize',16)


if isfield(dat, 'Mp')
  Mp = dat.Mp;
  % Overshoot
  zeta = -log(Mp)/sqrt(log(Mp)^2 + pi^2);
  
  h=fill(-[0;xx;xx],[0;xx*sqrt(1-zeta^2)/zeta*[1;-1]],'b');
  set(h,'facealpha',0.3,'linestyle','none')
end


if isfield(dat, 'Ts')
  Ts = dat.Ts;
  % Settling time
  h=fill([-4/Ts;-4/Ts;-xx;-xx],[-xx;xx;xx;-xx],'g');
  set(h,'facealpha',0.3,'linestyle','none')
end


if isfield(dat, 'Tp')
  Tp = dat.Tp;
  % Peak time
  wd = pi/Tp;
  h = fill([-xx;0;0;-xx],[wd;wd;xx;xx],'r');
  set(h,'facealpha',0.3,'linestyle','none')
  h = fill([-xx;0;0;-xx],-[wd;wd;xx;xx],'r');
  set(h,'facealpha',0.3,'linestyle','none')
end

set(gcf,'renderer','openGL');
axis([-xx xx -xx xx])
