# Install required package if not already installed
if (!require("quantmod")) install.packages("quantmod", dependencies = TRUE)
library(quantmod)

# Set date range
start_date <- as.Date("2000-01-03")
end_date <- as.Date("2024-12-31")

####### Group 1
# Tickers
tickers <- c("INTC", "AA", "GE")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("AA"=0.5, "GE"=0.3, "INTC"=0.2))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_01.Rdata")

####### Group 2
# Tickers
tickers <- c("JNJ", "MSFT", "XOM")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("JNJ"=0.55, "MSFT"=0.25, "XOM"=0.2))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_02.Rdata")

####### Group 3
# Tickers
tickers <- c("GE", "KO", "MMM")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("GE"=0.55, "KO"=0.25, "MMM"=0.2))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_03.Rdata")

####### Group 4
# Tickers
tickers <- c("HD", "JNJ", "PG")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("HD"=0.5, "JNJ"=0.3, "PG"=0.2))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_04.Rdata")

####### Group 5
# Tickers
tickers <- c("CSCO", "INTC", "MMM")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CSCO"=0.5, "INTC"=0.35, "MMM"=0.15))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_05.Rdata")

####### Group 6
# Tickers
tickers <- c("BA", "CSCO", "DD")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("BA"=0.55, "CSCO"=0.35, "DD"=0.10))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_06.Rdata")

####### Group 7
# Tickers
tickers <- c("AXP", "DIS", "MCD")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("AXP"=0.45, "DIS"=0.25, "MCD"=0.30))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_07.Rdata")

####### Group 8
# Tickers
tickers <- c("DIS", "HPQ", "MRK")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("DIS"=0.45, "HPQ"=0.35, "MRK"=0.20))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_08.Rdata")

####### Group 9
# Tickers
tickers <- c("AA", "INTC", "MMM")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("AA"=0.45, "INTC"=0.30, "MMM"=0.25))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_09.Rdata")

####### Group 11
# Tickers
tickers <- c("BAC", "CAT", "WMT")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("BAC"=0.5, "CAT"=0.25, "WMT"=0.25))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_11.Rdata")

####### Group 12
# Tickers
tickers <- c("CSCO", "MRK", "WMT")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CSCO"=0.55, "MRK"=0.3, "WMT"=0.15))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_12.Rdata")

####### Group 13
# Tickers
tickers <- c("IBM", "MMM", "WMT")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("IBM"=0.45, "MMM"=0.25, "WMT"=0.3))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_13.Rdata")

####### Group 14
# Tickers
tickers <- c("HPQ", "KO", "PFE")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("HPQ"=0.55, "KO"=0.35, "PFE"=0.10))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_14.Rdata")

####### Group 15
# Tickers
tickers <- c("CSCO", "MMM", "MSFT")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CSCO"=0.55, "MMM"=0.25, "MSFT"=0.20))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_15.Rdata")

####### Group 16
# Tickers
tickers <- c("AA", "BA", "CVX")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("AA"=0.45, "BA"=0.25, "CVX"=0.30))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_16.Rdata")

####### Group 17
# Tickers
tickers <- c("DD", "MRK", "WMT")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("DD"=0.5, "MRK"=0.3, "WMT"=0.2))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_17.Rdata")

####### Group 18
# Tickers
tickers <- c("DIS", "HPQ", "JNJ")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("DIS"=0.55, "HPQ"=0.3, "JNJ"=0.15))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_18.Rdata")

####### Group 19
# Tickers
tickers <- c("CAT", "DIS", "HPQ")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CAT"=0.55, "DIS"=0.25, "HPQ"=0.20))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_19.Rdata")

####### Group 20
# Tickers
tickers <- c("CVX", "GE", "XOM")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CVX"=0.5, "GE"=0.35, "XOM"=0.15))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_20.Rdata")

####### Group 21
# Tickers
tickers <- c("CSCO", "CVX", "IBM")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CSCO"=0.45, "CVX"=0.30, "IBM"=0.25))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_21.Rdata")

####### Group 10
# Tickers
tickers <- c("CAT", "DD", "HD")

# Download adjusted close prices and merge into one data frame
get_adjusted_close <- function(ticker) {
  getSymbols(ticker, src = "yahoo", from = start_date, to = end_date, auto.assign = FALSE)[, 6]
}

# Use lapply to get all tickers
adjusted_list <- lapply(tickers, get_adjusted_close)

# Combine into one data frame
adjusted_df <- do.call(merge, adjusted_list)

# Set column names to ticker symbols
colnames(adjusted_df) <- tickers

# Convert to regular data frame and add Date column
adjusted_df <- data.frame(Date = index(adjusted_df), coredata(adjusted_df))

# View the head
head(adjusted_df)

dataset <- list("prices"= adjusted_df,
                "dates.calib" = data.frame("Begin"= as.Date("2000-01-03"), "End"= as.Date("2018-07-29")),
                "dates.test" = data.frame("Begin"= as.Date("2018-08-02"), "End"= as.Date("2024-12-31")),
                "weights" = data.frame("CAT"=0.5, "DD"=0.35, "HD"=0.15))
save(dataset, file="/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects/dataset_10.Rdata")

folder_path <- "/Users/mhalla/switchdrive/EPFL/Teaching/Applied_Stat/Applied_Statistics_2025/Projects"

rdata_files <- list.files(path = folder_path, pattern = "\\.Rdata$", full.names = TRUE)

summary_list <- list()

for (file in rdata_files) {
  load(file)
  if (!is.null(dataset$prices) && is.data.frame(dataset$prices)) {
    ds <- dataset$prices
    n <- nrow(ds)
    summary_list[[basename(file)]] <- ds[c(1:2, (n-1):n), ]
  } else {
    warning(paste("No dataset found in", file))
  }
}

