"""File for initialization of linear wave equation."""

import numpy as np

def wavetest(x,a,z,delta,alpha,beta):
	"""Initial conditions for linear wave test problems."""
	N = len(x)
	u = np.zeros(N)

	for i in range(N):
		xi = x[i]
		# Gaussian wave
		if (xi >= -0.8 and xi <= -0.6):
			u[i] = 1.0/6*(Gwave(xi, beta, z-delta) + \
							Gwave(xi, beta, z+delta) + \
							4*Gwave(xi, beta, z))
		# Square wave
		if (xi >= -0.4 and xi <= -0.2):
			u[i] = 1.0

		# Triangle wave
		if (xi >= 0.0 and xi <= 0.2):
			u[i] = 1.0 - np.abs(10.0*(xi-0.1)) 

		#Ellipsoidal wave
		if (xi >= 0.4 and xi <= 0.6):
			u[i] = 1.0/6*(Fwave(xi, alpha, a-delta) + \
							Fwave(xi, alpha, a+delta) + \
							4.0*Fwave(xi, alpha, a))
	return u


def Gwave(x, beta, z):
	"""Special function of linear wave equation test."""
	G = np.exp(-beta*(x-z)**2)
	return G

def Fwave(x, alpha, a):
	"""Special function of linear wave equation test"""
	F = np.sqrt(max(1.0-alpha**2*(x-a)**2,0.0))
	return F
	
