"""Driver script for solving the 1D Maxwells equations using a spectral 
	Fourier collocation scheme"""

import numpy as np
import matplotlib.pyplot as plt
from MaxwellSpec import *
from MaxwellIC import CavityExactLong


# Set problem parameters
xmin = -2.0
xmax = 2.0
CFL = 0.1
FinalTime = np.pi/2
N = 64

# Define domain and initial conditions
L = xmax - xmin
x = xmin + L/(2*N+1)*np.arange(2*N+1)
epl = 1.0
mul = 1.0
epr = 2.25
mur = 1.0

q,ep,mu = CavityExactLong(x,epl,epr,mul,mur,0.0)


# Solve Problem
q = MaxwellSpec1D(x,q,ep,mu,N,L,CFL,FinalTime)

# Plot
plt.plot(x,q[0,:])
plt.title("Solution E at time {}".format(FinalTime))
plt.show()

