"""
This file contains all the basic implementations of functions to compute
quantities for the specific case of the linear wave equation.
"""

import numpy as np

def LinwaveLF(u, v, maxvel):
    """Purpose: Evaluate the Lax Friedrich numerical flux for Burgers equation"""
    
    flux = 0.5*(u+v)-0.5*maxvel*(v-u)
    return flux

def LinwaveLW(u,v,lambd):
	"""Purpose: Evaluate the Lax Wendroff numerical flux for Burgers equation"""

	numflux = (u+v)/2.0 - lambd/2.0*(v-u)
	return numflux
