"""Driver script for solving the 2D Euler equations using slope limited scheme"""

import numpy as np
import matplotlib.pyplot as plt
from EulerSlopeLimit import *
from EulerIC import *

# Set general problem parameters
CFL = 0.5
gamma = 1.4

# Set parameters for isentropic vortex
# Define domain and initial conditions
# Lx = 10.0
# Ly = 10.0
# Nx = 128
# Ny = 128
# hx = Lx/Nx
# hy = Ly/Ny
# xv = np.linspace(-5.0,5.0,Nx+1)
# yv = np.linspace(-5.0,5.0,Ny+1)
# x,v = np.meshgrid(xv,yv)
# x0 = 0.0
# y0 = 0.0
# u0 = 1.0
# v0 = 0.0
# beta = 5.0
# q = IsentropicVortex2D(x,x0,u0,y,y0,v0,gamma,beta,0)

# Set problem parameters for 2D Riemann problem
Lx = 1.0
Ly = 1.0
Nx = 199
Ny = 199
hx = Lx/Nx
hy = Ly/Ny
RiemannProbCase = 4

# Define domain and initial conditions
xv = np.linspace(0.0,1.0,Nx+1)
yv = np.linspace(0.0,1.0,Ny+1)
x,y = np.meshgrid(xv,yv)
q,FinalTime = Riemann2D(x,y,gamma,RiemannProbCase)

# Solve problem
q = EulerSL2D(x,y,q,hx,hy,gamma,CFL,FinalTime)


# Plot
plt.contour(x,y,q[0,:,:])
plt.title("Solution rho at time {}".format(FinalTime))
plt.show()

