
cd "/Users/fuster/Dropbox/Teaching/EPFL/phd_metrics/2024/ProblemSets/PS2"

cap log close 
log using solution/ps2.log, replace 

import delimited using JS_data.csv, varnames(1) clear


/////////////////////////////////
// Clean & define variables 
/////////////////////////////////

drop if state=="Delaware"

encode state, gen(statenr)
xtset statenr year

gen pi_real = pi_percap / cpi 

gen incg = (pi_real / l.pi_real - 1) * 100 

gen treatment_year = year==ma 

eststo clear 

// 2a)
reghdfe incg d if treatment_year!=1 & inrange(year,1972,1992), absorb(statenr year) vce(robust)

estadd ysumm
eststo 

reghdfe incg d if treatment_year!=1 & inrange(year,1972,1992) & !inlist(state,"Alaska","Hawaii"), absorb(statenr year#s year#mw year#w year#ne) vce(robust)

estadd ysumm
eststo 


// 2b) 
reghdfe incg d if inrange(year,1972,1992), absorb(statenr year) vce(robust)

estadd ysumm
eststo 

reghdfe incg d if inrange(year,1972,1992) & !inlist(state,"Alaska","Hawaii"), absorb(statenr year#s year#mw year#w year#ne) vce(robust)

estadd ysumm
eststo 


// 2c) 
reghdfe incg d if treatment_year!=1 & inrange(year,1972,1992), absorb(statenr year) vce(clu statenr)

estadd ysumm
eststo 

reghdfe incg d if treatment_year!=1 & inrange(year,1972,1992) & !inlist(state,"Alaska","Hawaii"), absorb(statenr year#s year#mw year#w year#ne) vce(clu statenr)

estadd ysumm
eststo 



// 2d)
reghdfe incg d if treatment_year!=1 & inrange(year,1972,1999), absorb(statenr year) vce(clu statenr)

estadd ysumm
eststo 

reghdfe incg d if treatment_year!=1 & inrange(year,1972,1999) & !inlist(state,"Alaska","Hawaii"), absorb(statenr year#s year#mw year#w year#ne) vce(clu statenr)

estadd ysumm
eststo 


esttab * using solution/q2.rtf , rtf replace b(3) se(3) starlevels(* 0.1 ** 0.05 *** 0.01) mtitle("2a Basic" "2a Regional" "2b Basic" "2b Regional" "2c Basic" "2c Regional" "2d Basic" "2d Regional") ///
 stat(N r2_a ymean ysd, fmt(0 3 2 2) label("Nr. obs." "Adj. R2" "Mean (dep. var.)" "SD (dep. var.)")) ///
 coeflabel(d "After deregulation" _cons "Constant") 


/////////////////////////////////
// Event study chart 
/////////////////////////////////

keep if inrange(year,1972,1992)


gen event_time = year - ma if inrange(ma,1971,1991)

eventdd incg, baseline(0) hdfe absorb(state year) vce(cluster state) timevar(event_time)

// the one shown in the solution writeup:
eventdd incg if !(ma == . | ma==1900), baseline(0)  timevar(event_time) hdfe absorb(state year) vce(cluster statenr) inrange leads(10) lags(10)  


// experimenting with xtevent 
xtset statenr year 

xtevent incg if !(ma == . | ma==1900), policy(d) w(5) cluster(statenr) note // impute(stag) // adding "impute(stag)" makes a big difference... 
xteventplot 



// manual version:

preserve 
	drop if (ma == . | ma==1900) // only keep those states that get deregulated during sample

	reghdfe incg d if treatment_year!=1, absorb(statenr year) vce(clu statenr) 
	// just to get overall treatment effect in this sample -- quite a bit larger
	
	gen yearsincetreat = year - ma
	tab yearsincetreat , gen(ysd)

	de ysd* 
	sum ysd*

	reghdfe incg ysd2-ysd29 ysd31-ysd47 ,  absorb(statenr year) vce(clu statenr)

	coefplot, drop(_cons) vert xlabel(,angle(45) labsize(tiny)) yline(0) name(manual, replace)

	coefplot, drop(_cons) vert xlabel(,angle(45) labsize(tiny)) yline(0) keep(ysd2? ysd3? ysd40) name(manual2, replace)
	
	// now redo with binning, just to see:

	replace yearsincetreat = -6 if yearsincetreat<-6
	replace yearsincetreat = 6  if yearsincetreat>6 & yearsincetreat<.
	
	drop ysd*
	tab yearsincetreat , gen(ysd)
	de ysd* 
	sum ysd*
	
	reghdfe incg ysd1-ysd6 ysd8-ysd13 ,  absorb(statenr year) vce(clu statenr)

	coefplot, drop(_cons) vert xlabel(,angle(45) labsize(tiny)) yline(0) name(manual_bins, replace)
	
restore 


/////////////////////////////////
// Goodman-Bacon 
/////////////////////////////////

xtset 
preserve 
	keep if incg<.
	xtreg incg d i.year, fe
	bacondecomp incg d
	
	/*
	xtreg incg d i.year, fe
	bacondecomp incg d , stub(Bacon_) ddetail
	*/ 
restore 



/////////////////////////////////
// Callaway-Sant'Anna 
/////////////////////////////////


csdid incg , ivar(statenr) time(year) gvar(ma) // could use "asinr" option but doesn't seem to make a difference

estat simple

estat event, window(-10 10)
csdid_plot


// Try did2s (Gardner) --  https://github.com/kylebutts/did2s_stata

did2s incg, first_stage(i.statenr i.year) second_stage(i.d) treatment(d) cluster(statenr)


log close 
