clear all
close all

%%%%%%%% Write down all the constants and parameters of Tab.s 1-4 %%%%%%%%%
%%%%%%%%       Important: make sure that units are consistent     %%%%%%%%%
% General constants -------------------------------------------------------
g       = 9.8;          % m/s^2         Gravitational acceleration
rhow    = 998;          % kg/m^3        Water density
k       = 0.41;         % -             Von Karman Constant
R       = 8.314;        % J/(mol K)     Universal Gas Constant
nuv     = 18/1000/rhow; % m^3/mol       Molecular volume of liquid water

% Plant parameters --------------------------------------------------------
Zr      = ...           % m             Rooting depth
LAI     = ...           % -             Leaf area per unit ground area
RAIW    = 5;            % -             Root Area Index under well watered conditions
hc      = ...           % m             Canopy height
a       = 8;            % -             Parameter accounting for root growth
c       = 2;            % -             Parameter of Vulnerability Curve
d1      = 2;            % MPa           Parameter of Vulnerability Curve
gpmax   = 11.7*1e-6;    % m/(MPa*s)     Maximum Plant Conductance
k1      = ...           % m^2/W         Parameter f_PAR
k2      = ...           % 1/K^2         Parameter f_Ta
Topt    = 298;          % K             Parameter f_Ta
Dx      = 1250/1e6;     % MPa           Parameter f_D 
psi_l0  = -4.5;         % MPa           Parameter f_psil
psi_l1  = -0.05;        % MPa           Parameter f_phil
gsmax   = 25*1e-6;      % m/s           Maximum stomatal conductance

% Soil Parameters (LOAM) --------------------------------------------------
s       = 0.35;         % -             Value(s) of soil saturation (Figure 1)
psiss   = ...           % MPa           Air entry suction point (Brooks Corey)
b       = 5.39;         % -             Parameter related to pore size distribution (Brooks Corey)
Ks      = ...           % m/s           Saturated hydraulic conductivity

% Atmospheric variables and parameters ------------------------------------
phi     = ...           % W/m2          Leaf available energy
RH      = 30;           % %             Relative humidity
Ta      = ...           % K             Air temperature
Uw      = 5;            % m/s           Wind Speed (in the slides it is Ua)
p0      = ...           % MPa           Atmospheric pressure
esat    = ...           % MPa           Saturated vapor pressure at Ta
ea      = ...           % MPa           Atmospheric vapor pressure
VPD     = ...           % MPa           Vapor pressure deficit   
d       = 0.7*hc;       % m             Displacement height
epsil   = d/10;         % m             Momentum roughness height   
epsilq  = 0.2*epsil;    % m             Water vapor roughness height
ga      = ...           % m/s           Aerodynamic conductance


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% COMPUTE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%% Implement Eq. (1) and Eq. (2) following point 2 %%%%%%%%%%%%%%

psi_l = -7:0.01:0; % MPa           Leaf water potential
T_l   = 293;       % K             Leaf temperature

for i=1:length(psi_l)
    % SOIL-TO-LEAF water flux
    g_srp(i)  = ... f(LAI,g_p(i),g_sr)
    E_1(i)    = ... f(g_srp(i),psi_s,psi_l(i))                 % m/s

    % LEAF-ATMOSPHERE flux (Jarvis’ model, 1976)
    if psi_l(i)<psi_l0
        f_psil(i) = 0;
    elseif psi_l(i)>psi_l1
        % ...
    else
        % ...
    end
    gs(i)  = ... f(gsmax,f_PAR,f_D,f_Ta,f_psil(i))
    gsa(i) = ... f(ga,gs(i))
    ei(i)  = ... f(esat(T_l),....)
    E_2(i) = ... f(gsa(i),el(i),...)
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%% PLOT the results %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
...
...
xlabel ('$\psi_l$ [MPa]','interpreter','latex')
ylabel ('$E$ [mm/day]','interpreter','latex')




