clear all
%% load data
%%%%% load the observation data for validation
load('\\enac1files\change\common\Teaching\Ecohydrological modeling\Exercises\T&C modelling\Exercise 1D\Swiss_Case_Studies\Pre_process\Res_CH-Cha.mat')
k=1; %% GPP type
Date_obs=Date;
%%% set up observed data
LE_obs=LE; %% latent heat
H_obs=H; %% sensible heat
Rn_obs=Rn; %% Net radiation
%%% GPP
GPP_all=[GPP1,GPP2,GPP3,GPP4];
GPP_obs=GPP_all(:,k); %% GPP type can be choosen

%%% load simulation results
load('\\enac1files.epfl.ch\change\common\Teaching\Ecohydrological modeling\Exercises\T&C modelling\Exercise 1D\Swiss_Case_Studies\results\CHAMAUtest.mat','NPP_H','NPP_L','RA_H','RA_L','Rn','H','QE','Ccrown','dateNum1','dateNum2')
%%% daily GPP calculation
GPP_H=(NPP_H+RA_H);
GPP_L=(NPP_L+RA_L);
GPP_sim=(GPP_H+GPP_L)*Ccrown';
LE_sim=QE;
%%% time index for observed data
index1 = find(Date_obs >= dateNum1, 1, 'first');
index2 = find(Date_obs >= dateNum2, 1, 'first');
x1=index1;
x2= index2;

Date=Date(x1:x2);
LE_obs=LE_obs(x1:x2); %% latent heat
H_obs=H_obs(x1:x2); %% sensible heat
Rn_obs=Rn_obs(x1:x2); %% Net radiation
GPP_obs=GPP_obs(x1:x2);
GPP_obs_daily = mean(reshape(GPP_obs, 24, []))';
%%% unit change from µmol CO₂/m²/s to gC/m²/day (fluxnet measurement and T&C simulation have different unit)
GPP_obs_daily=GPP_obs_daily*12*10^-6*24*3600; % gC/m²/day
%% plot the figures, note that GPP_sim may have one element more than GPP_obs_daily, one can use GPP_sim(2:end)

%% latent heat
%%% an example to plot time series of latent heat
figure(1),
plot(Date,LE_obs)
hold on
plot(Date,LE_sim)
ylabel('Latent heat [W/m^2]')
datetick('x', 'dd/mm/yyyy', 'keeplimits', 'keepticks');
set(gca,'FontSize',14)
legend('OBS','SIM')

%% TO DO
%%% try to plot also the 1:1 scatter plot and calculate goodness metrics

%% GPP
%%% an example to plot time series of GPP
time_plot=[Date(1):Date(end)];
figure(3),
plot(time_plot,GPP_obs_daily)
hold on
plot(time_plot,GPP_sim(2:end))
xlim([Date(1) Date(end)])
ylabel('Daily GPP [gC m^{-2} day^{-1}]')
datetick('x', 'dd/mm/yyyy', 'keeplimits', 'keepticks');
set(gca,'FontSize',14)
legend('OBS','SIM')

%% TO DO
%%% try to plot also the 1:1 scatter plot and calculate goodness metrics


%% sensible heat
%% TO DO
%%% plot time series of sensible heat

%%% try to plot also the 1:1 scatter plot and calculate goodness metrics



%% net radiation
%% TO DO
%%%% plot time series of net radiation (if the station has this measurement)

%%% try to plot also the 1:1 scatter plot and calculate goodness metrics
