%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% CLOSURE ENERGY BUDGET  DETERMINATION SURFACE TEMPERATURE %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[DQ]=Surface_Temperature_Debris(Ts,dt,Ta,ea,Latm,SvF,Pre,...
    Csno,Crock,Curb,Cbare,Ccrown,Cwat,Cice,...
    hc_H,hc_L,SnoDep,ydepth,ICE_D,Cdeb,Zs_deb,LAI_H,LAI_L,SAI_H,SAI_L,...
    RabsbSun_vegH,RabsbShd_vegH,Rabsb_soiH,...
    RabsbSun_vegL,RabsbShd_vegL,Rabsb_soiL,FsunH,FshdH,...
    FsunL,FshdL,Rabsb_sno,Rabsb_bare,Rabsb_urb,Rabsb_wat,Rabsb_rock,Rabsb_ice,Rabsb_deb,...
    e_sno,e_gr,e_sur,Cicew,Csnow,CLitter,...
    dw_L,dw_H,dw_SNO,...
    In_H,In_L,In_urb,In_rock,SWE,In_SWE,...
    Pr_liq,Pr_sno,rs_sunH,rs_sunL,rs_shdH,rs_shdL,d_leaf_H,d_leaf_L,r_litter,r_soil,b_soil,alp_soil,...
    Tdebtm1,Ticetm1,Deb_Par,ms_deb,...
    zatm,disp_h,zom,zoh,zom_under,disp_h_H,zom_H,disp_h_L,zom_L,Ws,In_Litter,alp_litter,Vavail,Vavail_plant_H,Vavail_plant_L,WAT_avail,ICEtm1)
%%%%%%%%%%%%%%%%%%%%%
[ra]=Aerodynamic_Resistence(Ta,Ts,Pre,zatm,disp_h,zom,zoh,Ws,ea);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[rap_H,rap_L,rb_H,rb_L]=Undercanopy_Leaf_Resistence2(Ws,Ta,Ts,Ccrown,hc_H,hc_L,...
    (LAI_H+SAI_H),(LAI_L+SAI_L),d_leaf_H,d_leaf_L,...
    zatm,disp_h,zom,zom_under,SnoDep,disp_h_H,zom_H,disp_h_L,zom_L);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Net Radiation
[Rnet]=Net_Radiation_Manager(Ts,Latm,SvF,...
    Csno,Crock,Curb,Cwat,Cbare,Cice,Ccrown,...
    hc_L,SnoDep,ydepth,ICE_D,Cdeb,LAI_H,LAI_L,SAI_H,SAI_L,...
    RabsbSun_vegH,RabsbShd_vegH,Rabsb_soiH,...
    RabsbSun_vegL,RabsbShd_vegL,Rabsb_soiL,FsunH,FshdH,...
    FsunL,FshdL,Rabsb_sno,Rabsb_bare,Rabsb_urb,Rabsb_wat,Rabsb_rock,Rabsb_ice,Rabsb_deb,...
    e_sno,e_gr,e_sur,Cicew,Csnow);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Debris Heat Flux
lan_deb =  Deb_Par.lan*ones(1,ms_deb) ;%%% [W/m K ] Thermal conductivity debris 
cv_deb =  Deb_Par.cs*Deb_Par.rho*ones(1,ms_deb); % [J/m^3 K]  Volumetric heat capcity debris 
[G]=Soil_Heat_Profile_Normal(Ts,dt,Tdebtm1,ms_deb,Zs_deb,lan_deb,cv_deb,Ticetm1,NaN,NaN,2); 

%%% Heat Fluxes
[H,QE,Qv]=Heat_fluxes(dt,...
    Ta,Ts,ea,Pre,Csno,Crock,Curb,Cwat,Cbare,Cice,Cicew,Csnow,CLitter,Cdeb,...
    dw_L,dw_H,dw_SNO,Ccrown,FsunH,FshdH,...
    FsunL,FshdL,LAI_H,LAI_L,SAI_H,SAI_L,...
    In_H,In_L,In_urb,In_rock,SWE,In_SWE,...
    Pr_liq,Pr_sno,ra,rs_sunH,rs_sunL,rs_shdH,rs_shdL,rb_H,rb_L,rap_H,rap_L,r_litter,...
    r_soil,b_soil,alp_soil,Vavail,Vavail_plant_H,Vavail_plant_L,WAT_avail,ICEtm1,In_Litter,alp_litter); 
%%%%%%% Energetic Balance
DQ = Rnet-H-QE-G+Qv;
end 


